/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.utils.item.updater;

import com.epam.ta.reportportal.entity.item.PathName;
import com.epam.ta.reportportal.ws.converter.converters.TestItemConverter;
import com.epam.ta.reportportal.ws.converter.utils.ResourceUpdater;
import com.epam.ta.reportportal.ws.reporting.TestItemResource;
import java.util.Map;
import java.util.Optional;

public class PathNameUpdater
implements ResourceUpdater<TestItemResource> {
    private final Map<Long, PathName> pathNamesMapping;

    private PathNameUpdater(Map<Long, PathName> pathNamesMapping) {
        this.pathNamesMapping = pathNamesMapping;
    }

    @Override
    public void updateResource(TestItemResource resource) {
        Optional.ofNullable(this.pathNamesMapping.get(resource.getItemId())).ifPresent(pathName -> resource.setPathNames(TestItemConverter.PATH_NAME_TO_RESOURCE.apply((PathName)pathName)));
    }

    public static PathNameUpdater of(Map<Long, PathName> pathNameMapping) {
        return new PathNameUpdater(pathNameMapping);
    }
}

