/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.converters;

import com.epam.ta.reportportal.core.analyzer.auto.impl.AnalyzerStatusCache;
import com.epam.ta.reportportal.dao.UserRepository;
import com.epam.ta.reportportal.entity.ItemAttribute;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.model.activity.LaunchActivityResource;
import com.epam.ta.reportportal.ws.converter.converters.StatisticsConverter;
import com.epam.ta.reportportal.ws.converter.resource.handler.attribute.ItemAttributeType;
import com.epam.ta.reportportal.ws.converter.resource.handler.attribute.ResourceAttributeHandler;
import com.epam.ta.reportportal.ws.converter.resource.handler.attribute.resolver.ItemAttributeTypeResolver;
import com.epam.ta.reportportal.ws.reporting.LaunchResource;
import com.epam.ta.reportportal.ws.reporting.LaunchResourceOld;
import com.epam.ta.reportportal.ws.reporting.Mode;
import com.epam.ta.reportportal.ws.reporting.RetentionPolicy;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LaunchConverter {
    @Autowired
    private AnalyzerStatusCache analyzerStatusCache;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private ItemAttributeTypeResolver itemAttributeTypeResolver;
    @Autowired
    private Map<ItemAttributeType, ResourceAttributeHandler<LaunchResource>> resourceAttributeUpdaterMapping;
    public static final Function<Launch, LaunchActivityResource> TO_ACTIVITY_RESOURCE = launch -> {
        LaunchActivityResource resource = new LaunchActivityResource();
        resource.setId(launch.getId());
        resource.setProjectId(launch.getProjectId());
        resource.setName(launch.getName() + " #" + launch.getNumber());
        return resource;
    };
    public Function<Launch, LaunchResource> TO_RESOURCE = db -> {
        Preconditions.checkNotNull((Object)db);
        LaunchResource resource = new LaunchResource();
        resource.setLaunchId(db.getId());
        resource.setUuid(db.getUuid());
        resource.setName(db.getName());
        resource.setNumber(db.getNumber());
        resource.setDescription(db.getDescription());
        resource.setStatus(db.getStatus() == null ? null : db.getStatus().toString());
        resource.setStartTime(db.getStartTime() == null ? null : db.getStartTime());
        resource.setEndTime(db.getEndTime() == null ? null : db.getEndTime());
        Optional.ofNullable(db.getLastModified()).ifPresent(arg_0 -> ((LaunchResource)resource).setLastModified(arg_0));
        Optional.ofNullable(db.getAttributes()).ifPresent(attributes -> this.updateAttributes(resource, (Set<ItemAttribute>)attributes));
        Optional.ofNullable(resource.getAttributes()).ifPresentOrElse(a -> {}, () -> resource.setAttributes(Collections.emptySet()));
        resource.setMode(db.getMode() == null ? null : Mode.valueOf((String)db.getMode().name()));
        resource.setRetentionPolicy(db.getRetentionPolicy() == null ? null : RetentionPolicy.valueOf((String)db.getRetentionPolicy().name()));
        resource.setAnalyzers(this.analyzerStatusCache.getStartedAnalyzers(db.getId()));
        resource.setStatisticsResource(StatisticsConverter.TO_RESOURCE.apply(db.getStatistics()));
        resource.setApproximateDuration(db.getApproximateDuration());
        resource.setHasRetries(db.isHasRetries());
        Optional.ofNullable(db.getUserId()).flatMap(id -> this.userRepository.findLoginById(id)).ifPresent(arg_0 -> ((LaunchResource)resource).setOwner(arg_0));
        resource.setRerun(db.isRerun());
        return resource;
    };
    public Function<LaunchResource, LaunchResourceOld> TO_RESOURCE_OLD = resource -> {
        LaunchResourceOld old = new LaunchResourceOld();
        old.setLaunchId(resource.getLaunchId());
        old.setUuid(resource.getUuid());
        old.setName(resource.getName());
        old.setNumber(resource.getNumber());
        old.setDescription(resource.getDescription());
        old.setStatus(resource.getStatus());
        old.setStartTime(resource.getStartTime());
        old.setEndTime(resource.getEndTime());
        old.setLastModified(resource.getLastModified());
        old.setAttributes(resource.getAttributes());
        old.setMode(resource.getMode());
        old.setRetentionPolicy(resource.getRetentionPolicy());
        old.setAnalyzers(resource.getAnalyzers());
        old.setStatisticsResource(resource.getStatisticsResource());
        old.setApproximateDuration(resource.getApproximateDuration());
        old.setHasRetries(resource.isHasRetries());
        old.setOwner(resource.getOwner());
        old.setRerun(resource.isRerun());
        return old;
    };

    private void updateAttributes(LaunchResource resource, Set<ItemAttribute> attributes) {
        Map attributeMapping = attributes.stream().collect(Collectors.groupingBy(attr -> this.itemAttributeTypeResolver.resolve((ItemAttribute)attr).orElse(ItemAttributeType.UNRESOLVED), Collectors.toSet()));
        attributeMapping.forEach((type, attr) -> this.resourceAttributeUpdaterMapping.get(type).handle(resource, (Collection<ItemAttribute>)attr));
    }
}

