/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.converters;

import com.epam.ta.reportportal.entity.bts.Ticket;
import com.epam.ta.reportportal.entity.item.issue.IssueEntity;
import com.epam.ta.reportportal.ws.reporting.Issue;
import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class IssueConverter {
    public static final Function<Issue, IssueEntity> TO_ISSUE = from -> {
        IssueEntity issue = new IssueEntity();
        issue.setAutoAnalyzed(Boolean.valueOf(from.isAutoAnalyzed()));
        issue.setIgnoreAnalyzer(Boolean.valueOf(from.isIgnoreAnalyzer()));
        issue.setIssueDescription(from.getComment());
        return issue;
    };
    public static final Function<Ticket, Issue.ExternalSystemIssue> TO_MODEL_EXTERNAL = externalSystemIssue -> {
        Issue.ExternalSystemIssue ticket = new Issue.ExternalSystemIssue();
        ticket.setTicketId(externalSystemIssue.getTicketId());
        ticket.setBtsUrl(externalSystemIssue.getBtsUrl());
        ticket.setUrl(externalSystemIssue.getUrl());
        ticket.setBtsProject(externalSystemIssue.getBtsProject());
        ticket.setPluginName(externalSystemIssue.getPluginName());
        return ticket;
    };
    public static final Function<IssueEntity, Issue> TO_MODEL = issueEntity -> {
        Preconditions.checkNotNull((Object)issueEntity);
        Issue issue = new Issue();
        issue.setIssueType(issueEntity.getIssueType().getLocator());
        issue.setAutoAnalyzed(issueEntity.getAutoAnalyzed().booleanValue());
        issue.setIgnoreAnalyzer(issueEntity.getIgnoreAnalyzer().booleanValue());
        issue.setComment(issueEntity.getIssueDescription());
        Optional.ofNullable(issueEntity.getTickets()).ifPresent(tickets -> issue.setExternalSystemIssues(tickets.stream().map(TO_MODEL_EXTERNAL).collect(Collectors.toSet())));
        return issue;
    };

    private IssueConverter() {
    }
}

