/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.converters;

import com.epam.reportportal.model.externalsystem.AllowedValue;
import com.epam.reportportal.model.externalsystem.PostFormField;
import com.epam.ta.reportportal.entity.bts.DefectFieldAllowedValue;
import com.epam.ta.reportportal.entity.bts.DefectFormField;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public final class IntegrationFieldsConverter {
    public static final Function<AllowedValue, DefectFieldAllowedValue> VALUE_TO_DB = value -> {
        Preconditions.checkNotNull((Object)value);
        DefectFieldAllowedValue allowedValue = new DefectFieldAllowedValue();
        allowedValue.setValueId(value.getValueId());
        allowedValue.setValueName(value.getValueName());
        return allowedValue;
    };
    public static final Function<PostFormField, DefectFormField> FIELD_TO_DB = field -> {
        Preconditions.checkNotNull((Object)field);
        DefectFormField defectFormField = new DefectFormField();
        defectFormField.setFieldId(field.getId());
        defectFormField.setType(field.getFieldType());
        defectFormField.setRequired(field.getIsRequired());
        if (!CollectionUtils.isEmpty((Collection)field.getValue())) {
            defectFormField.setValues(new HashSet(field.getValue()));
        }
        defectFormField.setDefectFieldAllowedValues(Optional.ofNullable(field.getDefinedValues()).map(dvs -> dvs.stream().map(VALUE_TO_DB).collect(Collectors.toSet())).orElseGet(Sets::newHashSet));
        return defectFormField;
    };
    public static final Function<DefectFieldAllowedValue, AllowedValue> VALUE_TO_MODEL = defectFieldAllowedValue -> {
        Preconditions.checkNotNull((Object)defectFieldAllowedValue);
        AllowedValue allowedValue = new AllowedValue();
        allowedValue.setValueId(defectFieldAllowedValue.getValueId());
        allowedValue.setValueName(defectFieldAllowedValue.getValueName());
        return allowedValue;
    };
    public static final Function<DefectFormField, PostFormField> FIELD_TO_MODEL = defectFormField -> {
        Preconditions.checkNotNull((Object)defectFormField);
        PostFormField postFormField = new PostFormField();
        postFormField.setId(defectFormField.getFieldId());
        postFormField.setFieldType(defectFormField.getType());
        postFormField.setIsRequired(defectFormField.isRequired());
        postFormField.setDefinedValues(defectFormField.getDefectFieldAllowedValues().stream().map(VALUE_TO_MODEL).collect(Collectors.toList()));
        postFormField.setValue(new ArrayList(defectFormField.getValues()));
        return postFormField;
    };

    private IntegrationFieldsConverter() {
    }
}

