/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.builders;

import com.epam.ta.reportportal.entity.enums.LogLevel;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.log.LogFull;
import com.epam.ta.reportportal.ws.reporting.SaveLogRQ;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;

public class LogFullBuilder
implements Supplier<LogFull> {
    private final LogFull logFull = new LogFull();

    public LogFullBuilder addSaveLogRq(SaveLogRQ createLogRQ) {
        this.logFull.setLogLevel(Integer.valueOf(LogLevel.toCustomLogLevel((String)createLogRQ.getLevel())));
        this.logFull.setLogMessage(Optional.ofNullable(createLogRQ.getMessage()).orElse("NULL"));
        this.logFull.setLogTime(createLogRQ.getLogTime());
        this.logFull.setUuid(Optional.ofNullable(createLogRQ.getUuid()).orElse(UUID.randomUUID().toString()));
        return this;
    }

    public LogFullBuilder addTestItem(TestItem testItem) {
        this.logFull.setTestItem(testItem);
        return this;
    }

    public LogFullBuilder addLaunch(Launch launch) {
        this.logFull.setLaunch(launch);
        return this;
    }

    public LogFullBuilder addProjectId(Long projectId) {
        this.logFull.setProjectId(projectId);
        return this;
    }

    @Override
    public LogFull get() {
        return this.logFull;
    }
}

