/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.builders;

import com.epam.ta.reportportal.entity.item.issue.IssueEntity;
import com.epam.ta.reportportal.entity.item.issue.IssueType;
import com.google.common.base.Preconditions;
import java.util.function.Supplier;

public class IssueEntityBuilder
implements Supplier<IssueEntity> {
    private IssueEntity issueEntity;

    public IssueEntityBuilder() {
        this.issueEntity = new IssueEntity();
    }

    public IssueEntityBuilder(IssueEntity issueEntity) {
        this.issueEntity = issueEntity;
    }

    public IssueEntityBuilder addIssueType(IssueType issueType) {
        Preconditions.checkNotNull((Object)issueType);
        this.issueEntity.setIssueType(issueType);
        return this;
    }

    public IssueEntityBuilder addDescription(String comment) {
        if (null != comment) {
            this.issueEntity.setIssueDescription(comment.trim());
        }
        return this;
    }

    public IssueEntityBuilder addIgnoreFlag(boolean ignoreAnalyzer) {
        this.issueEntity.setIgnoreAnalyzer(Boolean.valueOf(ignoreAnalyzer));
        return this;
    }

    public IssueEntityBuilder addAutoAnalyzedFlag(boolean autoAnalyzed) {
        this.issueEntity.setAutoAnalyzed(Boolean.valueOf(autoAnalyzed));
        return this;
    }

    @Override
    public IssueEntity get() {
        return this.issueEntity;
    }
}

