/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.core.filter.DeleteUserFilterHandler;
import com.epam.ta.reportportal.core.filter.GetUserFilterHandler;
import com.epam.ta.reportportal.core.filter.UpdateUserFilterHandler;
import com.epam.ta.reportportal.entity.filter.UserFilter;
import com.epam.ta.reportportal.model.CollectionsRQ;
import com.epam.ta.reportportal.model.EntryCreatedRS;
import com.epam.ta.reportportal.model.OwnedEntityResource;
import com.epam.ta.reportportal.model.Page;
import com.epam.ta.reportportal.model.filter.BulkUpdateFilterRQ;
import com.epam.ta.reportportal.model.filter.UpdateUserFilterRQ;
import com.epam.ta.reportportal.model.filter.UserFilterResource;
import com.epam.ta.reportportal.util.ProjectExtractor;
import com.epam.ta.reportportal.ws.converter.converters.UserFilterConverter;
import com.epam.ta.reportportal.ws.reporting.OperationCompletionRS;
import com.epam.ta.reportportal.ws.resolver.FilterFor;
import com.epam.ta.reportportal.ws.resolver.SortFor;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
@RequestMapping(value={"/v1/{projectName}/filter"})
@Tag(name="User Filter", description="User Filters API collection")
public class UserFilterController {
    private final ProjectExtractor projectExtractor;
    private final GetUserFilterHandler getFilterHandler;
    private final DeleteUserFilterHandler deleteFilterHandler;
    private final UpdateUserFilterHandler updateUserFilterHandler;

    @Autowired
    public UserFilterController(ProjectExtractor projectExtractor, GetUserFilterHandler getFilterHandler, DeleteUserFilterHandler deleteFilterHandler, UpdateUserFilterHandler updateUserFilterHandler) {
        this.projectExtractor = projectExtractor;
        this.getFilterHandler = getFilterHandler;
        this.deleteFilterHandler = deleteFilterHandler;
        this.updateUserFilterHandler = updateUserFilterHandler;
    }

    @Transactional
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @Operation(summary="Create user filter")
    public EntryCreatedRS createFilter(@PathVariable String projectName, @RequestBody @Validated UpdateUserFilterRQ createFilterRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.updateUserFilterHandler.createFilter(createFilterRQ, projectName, user);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/{filterId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get specified user filter by id")
    public UserFilterResource getFilter(@PathVariable String projectName, @PathVariable Long filterId, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getFilterHandler.getUserFilter(filterId, this.projectExtractor.extractProjectDetails(user, projectName));
    }

    @Transactional(readOnly=true)
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get filters")
    public Page<UserFilterResource> getAllFilters(@PathVariable String projectName, @SortFor(value=UserFilter.class) Pageable pageable, @FilterFor(value=UserFilter.class) Filter filter, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getFilterHandler.getUserFilters(projectName, pageable, filter, user);
    }

    @Transactional
    @DeleteMapping(value={"/{filterId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Delete specified user filter by id")
    public OperationCompletionRS deleteFilter(@PathVariable String projectName, @PathVariable Long filterId, @AuthenticationPrincipal ReportPortalUser user) {
        return this.deleteFilterHandler.deleteFilter(filterId, this.projectExtractor.extractProjectDetails(user, projectName), user);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/names"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get available filter names")
    public Page<OwnedEntityResource> getAllFiltersNames(@PathVariable String projectName, @SortFor(value=UserFilter.class) Pageable pageable, @FilterFor(value=UserFilter.class) Filter filter, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getFilterHandler.getFiltersNames(this.projectExtractor.extractProjectDetails(user, projectName), pageable, filter, user);
    }

    @Transactional
    @PutMapping(value={"/{filterId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Update specified user filter")
    public OperationCompletionRS updateUserFilter(@PathVariable String projectName, @PathVariable Long filterId, @RequestBody @Validated UpdateUserFilterRQ updateRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.updateUserFilterHandler.updateUserFilter(filterId, updateRQ, this.projectExtractor.extractProjectDetails(user, projectName), user);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/filters"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get list of specified user filters")
    public List<UserFilterResource> getUserFilters(@PathVariable String projectName, @RequestParam(value="ids") Long[] ids, @AuthenticationPrincipal ReportPortalUser user) {
        List<UserFilter> filters = this.getFilterHandler.getFiltersById(ids, this.projectExtractor.extractProjectDetails(user, projectName), user);
        return filters.stream().map(UserFilterConverter.TO_FILTER_RESOURCE).collect(Collectors.toList());
    }

    @Transactional
    @RequestMapping(method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Update list of user filters")
    public List<OperationCompletionRS> updateUserFilters(@PathVariable String projectName, @RequestBody @Validated CollectionsRQ<BulkUpdateFilterRQ> updateRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.updateUserFilterHandler.updateUserFilter(updateRQ, this.projectExtractor.extractProjectDetails(user, projectName), user);
    }
}

