/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.CompositeFilter;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.analyzer.auto.client.model.SuggestInfo;
import com.epam.ta.reportportal.core.analyzer.auto.impl.SuggestItemService;
import com.epam.ta.reportportal.core.analyzer.auto.impl.SuggestedItem;
import com.epam.ta.reportportal.core.item.DeleteTestItemHandler;
import com.epam.ta.reportportal.core.item.FinishTestItemHandler;
import com.epam.ta.reportportal.core.item.GetTestItemHandler;
import com.epam.ta.reportportal.core.item.StartTestItemHandler;
import com.epam.ta.reportportal.core.item.UpdateTestItemHandler;
import com.epam.ta.reportportal.core.item.history.TestItemsHistoryHandler;
import com.epam.ta.reportportal.core.item.impl.TestCaseSearchHandler;
import com.epam.ta.reportportal.core.item.impl.history.param.HistoryRequestParams;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.model.Page;
import com.epam.ta.reportportal.model.TestItemHistoryElement;
import com.epam.ta.reportportal.model.issue.DefineIssueRQ;
import com.epam.ta.reportportal.model.item.LinkExternalIssueRQ;
import com.epam.ta.reportportal.model.item.UnlinkExternalIssueRQ;
import com.epam.ta.reportportal.model.item.UpdateTestItemRQ;
import com.epam.ta.reportportal.util.ProjectExtractor;
import com.epam.ta.reportportal.ws.converter.converters.TestItemConverter;
import com.epam.ta.reportportal.ws.reporting.BulkInfoUpdateRQ;
import com.epam.ta.reportportal.ws.reporting.EntryCreatedAsyncRS;
import com.epam.ta.reportportal.ws.reporting.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.reporting.Issue;
import com.epam.ta.reportportal.ws.reporting.OperationCompletionRS;
import com.epam.ta.reportportal.ws.reporting.StartTestItemRQ;
import com.epam.ta.reportportal.ws.reporting.StatisticsResource;
import com.epam.ta.reportportal.ws.reporting.TestItemResource;
import com.epam.ta.reportportal.ws.reporting.TestItemResourceOld;
import com.epam.ta.reportportal.ws.resolver.FilterFor;
import com.epam.ta.reportportal.ws.resolver.SortFor;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jooq.Operator;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/{projectName}/item"})
@PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
@Tag(name="Test Item", description="Test Items API collection")
public class TestItemController {
    public static final String HISTORY_TYPE_PARAM = "type";
    public static final String FILTER_ID_REQUEST_PARAM = "filterId";
    public static final String IS_LATEST_LAUNCHES_REQUEST_PARAM = "isLatest";
    public static final String LAUNCHES_LIMIT_REQUEST_PARAM = "launchesLimit";
    private static final String HISTORY_DEPTH_PARAM = "historyDepth";
    private static final String HISTORY_DEPTH_DEFAULT_VALUE = "5";
    private static final String LAUNCHES_LIMIT_DEFAULT_VALUE = "0";
    private final ProjectExtractor projectExtractor;
    private final StartTestItemHandler startTestItemHandler;
    private final DeleteTestItemHandler deleteTestItemHandler;
    private final FinishTestItemHandler finishTestItemHandler;
    private final UpdateTestItemHandler updateTestItemHandler;
    private final GetTestItemHandler getTestItemHandler;
    private final TestItemsHistoryHandler testItemsHistoryHandler;
    private final SuggestItemService suggestItemService;
    private final TestCaseSearchHandler testCaseSearchHandler;

    @PostMapping(value={"", "/"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @Operation(summary="Start a root test item")
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')||hasRole('ADMINISTRATOR')")
    public EntryCreatedAsyncRS startRootItem(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @RequestBody @Validated StartTestItemRQ startTestItemRQ) {
        return this.startTestItemHandler.startRootItem(user, this.projectExtractor.extractProjectDetails(user, projectName), startTestItemRQ);
    }

    @PostMapping(value={"/{parentItem}", "/{parentItem}/"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @Operation(summary="Start a child test item")
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')||hasRole('ADMINISTRATOR')")
    public EntryCreatedAsyncRS startChildItem(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @PathVariable String parentItem, @RequestBody @Validated StartTestItemRQ startTestItemRQ) {
        return this.startTestItemHandler.startChildItem(user, this.projectExtractor.extractProjectDetails(user, projectName), startTestItemRQ, parentItem);
    }

    @PutMapping(value={"/{testItemId}", "/{testItemId}/"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Finish test item")
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')||hasRole('ADMINISTRATOR')")
    public OperationCompletionRS finishTestItem(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @PathVariable String testItemId, @RequestBody @Validated FinishTestItemRQ finishExecutionRQ) {
        return this.finishTestItemHandler.finishTestItem(user, this.projectExtractor.extractProjectDetails(user, projectName), testItemId, finishExecutionRQ);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/{itemId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Find test item by ID")
    public TestItemResource getTestItem(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @PathVariable String itemId) {
        return this.getTestItemHandler.getTestItem(itemId, this.projectExtractor.extractProjectDetails(user, projectName), user);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/uuid/{itemId}"}, produces={"application/x.reportportal.test.v2+json"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Find test item by UUID")
    public TestItemResource getTestItemByUuid(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @PathVariable String itemId) {
        return this.getTestItemHandler.getTestItem(itemId, this.projectExtractor.extractProjectDetails(user, projectName), user);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/uuid/{itemId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Find test item by UUID")
    @ApiResponse(responseCode="200", description="Successful response with dates in timestamp format. Response with dates in ISO-8601 format if the custom header 'Accept: application/x.reportportal.test.v2+json' is used.", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestItemResourceOld.class))})
    public TestItemResourceOld getTestItemByUuidTimestamp(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @PathVariable String itemId) {
        TestItemResource testItem = this.getTestItemHandler.getTestItem(itemId, this.projectExtractor.extractProjectDetails(user, projectName), user);
        return TestItemConverter.TO_RESOURCE_TIMESTAMP.apply(testItem);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/suggest/{itemId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Search suggested items in analyzer for provided one")
    public List<SuggestedItem> getSuggestedItems(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @PathVariable Long itemId) {
        return this.suggestItemService.suggestItems(itemId, this.projectExtractor.extractProjectDetails(user, projectName), user);
    }

    @GetMapping(value={"/suggest/cluster/{clusterId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Search suggested items in analyzer for provided one")
    public List<SuggestedItem> getSuggestedClusterItems(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @PathVariable Long clusterId) {
        return this.suggestItemService.suggestClusterItems(clusterId, this.projectExtractor.extractProjectDetails(user, projectName), user);
    }

    @Transactional
    @PutMapping(value={"/suggest/choice"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Handle user choice from suggested items")
    public OperationCompletionRS handleSuggestChoose(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @RequestBody @Validated List<SuggestInfo> request) {
        this.projectExtractor.extractProjectDetails(user, projectName);
        return this.suggestItemService.handleSuggestChoice(request);
    }

    @Transactional(readOnly=true)
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Find test items by specified filter")
    @Schema(implementation=TestItemHistoryElement.class)
    public Page<TestItemResource> getTestItems(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @Nullable @Parameter(hidden=true) @RequestParam(value="filter.eq.launchId", required=false) Long launchId, @Nullable @RequestParam(value="filterId", required=false) Long filterId, @RequestParam(value="isLatest", defaultValue="false", required=false) boolean isLatest, @RequestParam(value="launchesLimit", defaultValue="0", required=false) int launchesLimit, @FilterFor(value=TestItem.class) Filter filter, @FilterFor(value=TestItem.class) Queryable predefinedFilter, @SortFor(value=TestItem.class) Pageable pageable) {
        return this.getTestItemHandler.getTestItems((Queryable)new CompositeFilter(Operator.AND, new Queryable[]{filter, predefinedFilter}), pageable, this.projectExtractor.extractProjectDetails(user, projectName), user, launchId, filterId, isLatest, launchesLimit);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/v2"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Find test items by specified filter")
    public Page<TestItemResource> getTestItemsV2(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @RequestParam Map<String, String> params, @FilterFor(value=TestItem.class) Filter filter, @FilterFor(value=TestItem.class) Queryable predefinedFilter, @SortFor(value=TestItem.class) Pageable pageable) {
        if ("libg-140".equalsIgnoreCase(projectName)) {
            return null;
        }
        return this.getTestItemHandler.getTestItemsByProvider((Queryable)new CompositeFilter(Operator.AND, new Queryable[]{filter, predefinedFilter}), pageable, this.projectExtractor.extractProjectDetails(user, projectName), user, params);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/statistics"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Find accumulated statistics of items by specified filter")
    public StatisticsResource getTestItems(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @FilterFor(value=TestItem.class) Filter filter, @FilterFor(value=TestItem.class) Queryable predefinedFilter, @RequestParam Map<String, String> params) {
        return this.getTestItemHandler.getStatisticsByProvider((Queryable)new CompositeFilter(Operator.AND, new Queryable[]{filter, predefinedFilter}), this.projectExtractor.extractProjectDetails(user, projectName), user, params);
    }

    @Transactional
    @DeleteMapping(value={"/{itemId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Delete test item")
    public OperationCompletionRS deleteTestItem(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @PathVariable Long itemId) {
        return this.deleteTestItemHandler.deleteTestItem(itemId, this.projectExtractor.extractProjectDetails(user, projectName), user);
    }

    @Transactional
    @DeleteMapping
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Delete test items by specified ids")
    public List<OperationCompletionRS> deleteTestItems(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @RequestParam(value="ids") Set<Long> ids) {
        return this.deleteTestItemHandler.deleteTestItems(ids, this.projectExtractor.extractProjectDetails(user, projectName), user);
    }

    @Transactional
    @PutMapping
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Update issues of specified test items")
    public List<Issue> defineTestItemIssueType(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @RequestBody @Validated DefineIssueRQ request) {
        return this.updateTestItemHandler.defineTestItemsIssues(this.projectExtractor.extractProjectDetails(user, projectName), request, user);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/history"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Load history of test items")
    public Page<TestItemHistoryElement> getItemsHistory(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @FilterFor(value=TestItem.class) Filter filter, @FilterFor(value=TestItem.class) Queryable predefinedFilter, @SortFor(value=TestItem.class) Pageable pageable, @Nullable @Parameter(hidden=true) @RequestParam(value="filter.eq.parentId", required=false) Long parentId, @Nullable @Parameter(hidden=true) @RequestParam(value="filter.eq.id", required=false) Long itemId, @Nullable @Parameter(hidden=true) @RequestParam(value="filter.eq.launchId", required=false) Long launchId, @Nullable @RequestParam(value="type", required=false) String type, @Nullable @RequestParam(value="filterId", required=false) Long filterId, @RequestParam(value="isLatest", defaultValue="false", required=false) boolean isLatest, @RequestParam(value="launchesLimit", defaultValue="0", required=false) int launchesLimit, @RequestParam(value="historyDepth", required=false, defaultValue="5") int historyDepth) {
        return this.testItemsHistoryHandler.getItemsHistory(this.projectExtractor.extractProjectDetails(user, projectName), (Queryable)new CompositeFilter(Operator.AND, new Queryable[]{filter, predefinedFilter}), pageable, HistoryRequestParams.of(historyDepth, parentId, itemId, launchId, type, filterId, launchesLimit, isLatest), user);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/ticket/ids"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get tickets that contains a term as a part inside for specified launch")
    public List<String> getTicketIds(@AuthenticationPrincipal ReportPortalUser user, @PathVariable String projectName, @RequestParam(value="launch") Long id, @RequestParam(value="term") String term) {
        return this.getTestItemHandler.getTicketIds(id, EntityUtils.normalizeId((String)term));
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/ticket/ids/all"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get tickets that contains a term as a part inside for specified launch")
    public List<String> getTicketIdsForProject(@AuthenticationPrincipal ReportPortalUser user, @PathVariable String projectName, @RequestParam(value="term") String term) {
        return this.getTestItemHandler.getTicketIds(this.projectExtractor.extractProjectDetails(user, projectName), EntityUtils.normalizeId((String)term));
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/attribute/keys"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get all unique attribute keys on the project")
    public List<String> getUniqueAttributeKeys(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @RequestParam(value="launch", required=false) Long launchId, @RequestParam(value="filter.cnt.attributeKey") String keyPart) {
        return this.getTestItemHandler.getUniqueAttributeKeys(this.projectExtractor.extractProjectDetails(user, projectName), keyPart, launchId);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/attribute/values"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get all unique attribute values on the project")
    public List<String> getAttributeValues(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @RequestParam(value="launch", required=false) Long launchId, @RequestParam(value="filter.eq.attributeKey", required=false) String key, @RequestParam(value="filter.cnt.attributeValue") String valuePart) {
        return this.getTestItemHandler.getUniqueAttributeValues(this.projectExtractor.extractProjectDetails(user, projectName), key, valuePart, launchId);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/attribute/keys/all"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get all unique attribute keys of specified launch")
    public List<String> getAttributeKeysForProject(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @RequestParam(value="filter.cnt.attributeKey") String value, @RequestParam(value="filterId") Long launchFilterId, @RequestParam(value="isLatest", defaultValue="false", required=false) boolean isLatest, @RequestParam(value="launchesLimit", defaultValue="0") int launchesLimit) {
        return this.getTestItemHandler.getAttributeKeys(launchFilterId, isLatest, launchesLimit, this.projectExtractor.extractProjectDetails(user, projectName), value);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/step/attribute/keys"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get all unique attribute keys of step items under specified project")
    public List<String> getAttributeKeys(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @RequestParam(value="filter.eq.name", required=false) String launchName, @RequestParam(value="filter.cnt.attributeKey") String value) {
        return Optional.ofNullable(launchName).filter(StringUtils::isNotBlank).map(name -> this.getTestItemHandler.getAttributeKeys(this.projectExtractor.extractProjectDetails(user, projectName), (String)name, value)).orElseGet(Collections::emptyList);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/step/attribute/values"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get all unique attribute values of step items under specified project")
    public List<String> getAttributeValues(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @RequestParam(value="filter.eq.name", required=false) String launchName, @RequestParam(value="filter.eq.attributeKey", required=false) String key, @RequestParam(value="filter.cnt.attributeValue") String value) {
        return Optional.ofNullable(launchName).filter(StringUtils::isNotBlank).map(name -> this.getTestItemHandler.getAttributeValues(this.projectExtractor.extractProjectDetails(user, projectName), (String)name, key, value)).orElseGet(Collections::emptyList);
    }

    @Transactional
    @PutMapping(value={"/info"})
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')||hasRole('ADMINISTRATOR')")
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Bulk update attributes and description")
    public OperationCompletionRS bulkUpdate(@PathVariable String projectName, @RequestBody @Validated BulkInfoUpdateRQ bulkInfoUpdateRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.updateTestItemHandler.bulkInfoUpdate(bulkInfoUpdateRQ, this.projectExtractor.extractProjectDetails(user, projectName));
    }

    @Transactional
    @PutMapping(value={"/{itemId}/update"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Update test item")
    public OperationCompletionRS updateTestItem(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @PathVariable Long itemId, @RequestBody @Validated UpdateTestItemRQ rq) {
        return this.updateTestItemHandler.updateTestItem(this.projectExtractor.extractProjectDetails(user, projectName), itemId, rq, user);
    }

    @Transactional
    @PutMapping(value={"/issue/link"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Attach external issue for specified test items")
    public List<OperationCompletionRS> linkExternalIssues(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @RequestBody @Validated LinkExternalIssueRQ rq) {
        return this.updateTestItemHandler.processExternalIssues(rq, this.projectExtractor.extractProjectDetails(user, projectName), user);
    }

    @Transactional
    @PutMapping(value={"/issue/unlink"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Unlink external issue for specified test items")
    public List<OperationCompletionRS> unlinkExternalIssues(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @RequestBody @Validated UnlinkExternalIssueRQ rq) {
        return this.updateTestItemHandler.processExternalIssues(rq, this.projectExtractor.extractProjectDetails(user, projectName), user);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/items"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get test items by specified ids")
    public List<TestItemResource> getTestItems(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @RequestParam(value="ids") Long[] ids) {
        return this.getTestItemHandler.getTestItems(ids, this.projectExtractor.extractProjectDetails(user, projectName), user);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/search"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Search test items by either name or attribute")
    public Page<TestItemResource> getTestItems(@PathVariable String projectName, @AuthenticationPrincipal ReportPortalUser user, @RequestParam(value="filter.cnt.name", required=false) String name, @RequestParam(value="filter.has.compositeAttribute", required=false) String attribute, @RequestParam(value="filter.in.status", required=false) String status, Pageable pageable) {
        return this.testCaseSearchHandler.searchTestItems(name, attribute, status, pageable, this.projectExtractor.extractProjectDetails(user, projectName));
    }

    @Generated
    public TestItemController(ProjectExtractor projectExtractor, StartTestItemHandler startTestItemHandler, DeleteTestItemHandler deleteTestItemHandler, FinishTestItemHandler finishTestItemHandler, UpdateTestItemHandler updateTestItemHandler, GetTestItemHandler getTestItemHandler, TestItemsHistoryHandler testItemsHistoryHandler, SuggestItemService suggestItemService, TestCaseSearchHandler testCaseSearchHandler) {
        this.projectExtractor = projectExtractor;
        this.startTestItemHandler = startTestItemHandler;
        this.deleteTestItemHandler = deleteTestItemHandler;
        this.finishTestItemHandler = finishTestItemHandler;
        this.updateTestItemHandler = updateTestItemHandler;
        this.getTestItemHandler = getTestItemHandler;
        this.testItemsHistoryHandler = testItemsHistoryHandler;
        this.suggestItemService = suggestItemService;
        this.testCaseSearchHandler = testCaseSearchHandler;
    }
}

