/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller;

import com.epam.reportportal.model.launch.cluster.ClusterInfoResource;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.core.jasper.GetJasperReportHandler;
import com.epam.ta.reportportal.core.launch.DeleteLaunchHandler;
import com.epam.ta.reportportal.core.launch.FinishLaunchHandler;
import com.epam.ta.reportportal.core.launch.GetLaunchHandler;
import com.epam.ta.reportportal.core.launch.MergeLaunchHandler;
import com.epam.ta.reportportal.core.launch.StartLaunchHandler;
import com.epam.ta.reportportal.core.launch.StopLaunchHandler;
import com.epam.ta.reportportal.core.launch.UpdateLaunchHandler;
import com.epam.ta.reportportal.core.launch.util.LinkGenerator;
import com.epam.ta.reportportal.entity.jasper.ReportFormat;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.widget.content.ChartStatisticsContent;
import com.epam.ta.reportportal.model.BulkRQ;
import com.epam.ta.reportportal.model.DeleteBulkRS;
import com.epam.ta.reportportal.model.Page;
import com.epam.ta.reportportal.model.launch.AnalyzeLaunchRQ;
import com.epam.ta.reportportal.model.launch.FinishLaunchRS;
import com.epam.ta.reportportal.model.launch.UpdateLaunchRQ;
import com.epam.ta.reportportal.model.launch.cluster.CreateClustersRQ;
import com.epam.ta.reportportal.util.ProjectExtractor;
import com.epam.ta.reportportal.ws.converter.converters.LaunchConverter;
import com.epam.ta.reportportal.ws.reporting.BulkInfoUpdateRQ;
import com.epam.ta.reportportal.ws.reporting.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.reporting.LaunchResource;
import com.epam.ta.reportportal.ws.reporting.LaunchResourceOld;
import com.epam.ta.reportportal.ws.reporting.MergeLaunchesRQ;
import com.epam.ta.reportportal.ws.reporting.OperationCompletionRS;
import com.epam.ta.reportportal.ws.reporting.StartLaunchRQ;
import com.epam.ta.reportportal.ws.reporting.StartLaunchRS;
import com.epam.ta.reportportal.ws.resolver.FilterFor;
import com.epam.ta.reportportal.ws.resolver.SortFor;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/{projectName}/launch"})
@Tag(name="Launch", description="Launches API collection")
public class LaunchController {
    private final ProjectExtractor projectExtractor;
    private final StartLaunchHandler startLaunchHandler;
    private final FinishLaunchHandler finishLaunchHandler;
    private final StopLaunchHandler stopLaunchHandler;
    private final DeleteLaunchHandler deleteLaunchMessageHandler;
    private final GetLaunchHandler getLaunchMessageHandler;
    private final UpdateLaunchHandler updateLaunchHandler;
    private final MergeLaunchHandler mergeLaunchesHandler;
    private final GetJasperReportHandler<Launch> getJasperHandler;
    private final LaunchConverter launchConverter;

    @Autowired
    public LaunchController(ProjectExtractor projectExtractor, StartLaunchHandler startLaunchHandler, FinishLaunchHandler finishLaunchHandler, StopLaunchHandler stopLaunchHandler, DeleteLaunchHandler deleteLaunchMessageHandler, GetLaunchHandler getLaunchMessageHandler, UpdateLaunchHandler updateLaunchHandler, MergeLaunchHandler mergeLaunchesHandler, @Qualifier(value="launchJasperReportHandler") GetJasperReportHandler<Launch> getJasperHandler, LaunchConverter launchConverter) {
        this.projectExtractor = projectExtractor;
        this.startLaunchHandler = startLaunchHandler;
        this.finishLaunchHandler = finishLaunchHandler;
        this.stopLaunchHandler = stopLaunchHandler;
        this.deleteLaunchMessageHandler = deleteLaunchMessageHandler;
        this.getLaunchMessageHandler = getLaunchMessageHandler;
        this.updateLaunchHandler = updateLaunchHandler;
        this.mergeLaunchesHandler = mergeLaunchesHandler;
        this.getJasperHandler = getJasperHandler;
        this.launchConverter = launchConverter;
    }

    @PostMapping
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')||hasRole('ADMINISTRATOR')")
    @ResponseStatus(value=HttpStatus.CREATED)
    @Operation(summary="Starts launch for specified project")
    public StartLaunchRS startLaunch(@PathVariable String projectName, @Parameter(description="Start launch request body", required=true) @RequestBody @Validated @Valid StartLaunchRQ startLaunchRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.startLaunchHandler.startLaunch(user, this.projectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), startLaunchRQ);
    }

    @PutMapping(value={"/{launchId}/finish"})
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')||hasRole('ADMINISTRATOR')")
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Finish launch for specified project")
    public FinishLaunchRS finishLaunch(@PathVariable String projectName, @PathVariable String launchId, @RequestBody @Validated FinishExecutionRQ finishLaunchRQ, @AuthenticationPrincipal ReportPortalUser user, HttpServletRequest request) {
        return this.finishLaunchHandler.finishLaunch(launchId, finishLaunchRQ, this.projectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), user, LinkGenerator.composeBaseUrl(request));
    }

    @Transactional
    @PutMapping(value={"/{launchId}/stop"})
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')||hasRole('ADMINISTRATOR')")
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Force finish launch for specified project")
    public OperationCompletionRS forceFinishLaunch(@PathVariable String projectName, @PathVariable Long launchId, @RequestBody @Validated FinishExecutionRQ finishExecutionRQ, @AuthenticationPrincipal ReportPortalUser user, HttpServletRequest request) {
        return this.stopLaunchHandler.stopLaunch(launchId, finishExecutionRQ, this.projectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), user, LinkGenerator.composeBaseUrl(request));
    }

    @Transactional
    @PutMapping(value={"/stop"})
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')||hasRole('ADMINISTRATOR')")
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Force finish launch")
    public List<OperationCompletionRS> bulkForceFinish(@PathVariable String projectName, @RequestBody @Validated BulkRQ<Long, FinishExecutionRQ> rq, @AuthenticationPrincipal ReportPortalUser user, HttpServletRequest request) {
        return this.stopLaunchHandler.stopLaunch(rq, this.projectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), user, LinkGenerator.composeBaseUrl(request));
    }

    @Transactional
    @PutMapping(value={"/{launchId}/update"})
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')||hasRole('ADMINISTRATOR')")
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Updates launch for specified project")
    public OperationCompletionRS updateLaunch(@PathVariable String projectName, @PathVariable Long launchId, @RequestBody @Validated UpdateLaunchRQ updateLaunchRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.updateLaunchHandler.updateLaunch(launchId, this.projectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), user, updateLaunchRQ);
    }

    @Transactional
    @PutMapping(value={"/update"})
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')||hasRole('ADMINISTRATOR')")
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Updates launches for specified project")
    public List<OperationCompletionRS> updateLaunches(@PathVariable String projectName, @RequestBody @Validated BulkRQ<Long, UpdateLaunchRQ> rq, @AuthenticationPrincipal ReportPortalUser user) {
        return this.updateLaunchHandler.updateLaunch(rq, this.projectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), user);
    }

    @Transactional
    @DeleteMapping(value={"/{launchId}"})
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')||hasRole('ADMINISTRATOR')")
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Delete specified launch by ID")
    public OperationCompletionRS deleteLaunch(@PathVariable String projectName, @PathVariable Long launchId, @AuthenticationPrincipal ReportPortalUser user) {
        return this.deleteLaunchMessageHandler.deleteLaunch(launchId, this.projectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), user);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/{launchId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get specified launch by ID")
    public LaunchResource getLaunch(@PathVariable String projectName, @PathVariable String launchId, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getLaunchMessageHandler.getLaunch(launchId, this.projectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)));
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/uuid/{launchId}"}, produces={"application/x.reportportal.launch.v2+json"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get specified launch by UUID")
    public LaunchResource getLaunchByUuid(@PathVariable String projectName, @PathVariable String launchId, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getLaunchMessageHandler.getLaunch(launchId, this.projectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)));
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/uuid/{launchId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get specified launch by UUID")
    @ApiResponse(responseCode="200", description="Successful response with dates in timestamp format. Response with dates in ISO-8601 format if the custom header 'Accept: application/x.reportportal.launch.v2+json' is used.", content={@Content(mediaType="application/json", schema=@Schema(implementation=LaunchResourceOld.class))})
    public LaunchResourceOld getLaunchByUuidOldTimestamp(@PathVariable String projectName, @PathVariable String launchId, @AuthenticationPrincipal ReportPortalUser user) {
        LaunchResource launch = this.getLaunchMessageHandler.getLaunch(launchId, this.projectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)));
        return this.launchConverter.TO_RESOURCE_OLD.apply(launch);
    }

    @Transactional(readOnly=true)
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get list of project launches by filter")
    public Page<LaunchResource> getProjectLaunches(@PathVariable String projectName, @FilterFor(value=Launch.class) Filter filter, @SortFor(value=Launch.class) Pageable pageable, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getLaunchMessageHandler.getProjectLaunches(this.projectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), filter, pageable, user.getUsername());
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/latest"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get list of latest project launches by filter")
    public Page<LaunchResource> getLatestLaunches(@PathVariable String projectName, @FilterFor(value=Launch.class) Filter filter, @SortFor(value=Launch.class) Pageable pageable, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getLaunchMessageHandler.getLatestLaunches(this.projectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), filter, pageable);
    }

    @GetMapping(value={"/mode"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get launches of specified project from DEBUG mode")
    public Page<LaunchResource> getDebugLaunches(@PathVariable String projectName, @FilterFor(value=Launch.class) Filter filter, @SortFor(value=Launch.class) Pageable pageable, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getLaunchMessageHandler.getDebugLaunches(this.projectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), filter, pageable);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/attribute/keys"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get all unique attribute keys of project launches")
    public List<String> getAttributeKeys(@PathVariable String projectName, @RequestParam(value="filter.cnt.attributeKey") String value, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getLaunchMessageHandler.getAttributeKeys(this.projectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), value);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/attribute/values"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get all unique attribute values of project launches")
    public List<String> getAttributeValues(@PathVariable String projectName, @RequestParam(value="filter.eq.attributeKey", required=false) String key, @RequestParam(value="filter.cnt.attributeValue") String value, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getLaunchMessageHandler.getAttributeValues(this.projectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), key, value);
    }

    @GetMapping(value={"/cluster/{launchId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get all index clusters of the launch")
    public Page<ClusterInfoResource> getClusters(@PathVariable String projectName, @PathVariable String launchId, Pageable pageable, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getLaunchMessageHandler.getClusters(launchId, this.projectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), pageable);
    }

    @Transactional
    @PutMapping(value={"/info"})
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')||hasRole('ADMINISTRATOR')")
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Bulk update attributes and description")
    public OperationCompletionRS bulkUpdate(@PathVariable String projectName, @RequestBody @Validated BulkInfoUpdateRQ bulkInfoUpdateRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.updateLaunchHandler.bulkInfoUpdate(bulkInfoUpdateRQ, this.projectExtractor.extractProjectDetails(user, projectName));
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/owners"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get all unique owners of project launches")
    public List<String> getAllOwners(@PathVariable String projectName, @RequestParam(value="filter.cnt.user") String value, @RequestParam(value="mode", required=false, defaultValue="DEFAULT") String mode, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getLaunchMessageHandler.getOwners(this.projectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), value, mode);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/names"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Get launch names of project")
    public List<String> getAllLaunchNames(@PathVariable String projectName, @RequestParam(value="filter.cnt.name", required=false, defaultValue="") String value, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getLaunchMessageHandler.getLaunchNames(this.projectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), value);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/compare"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Compare launches")
    public Map<String, List<ChartStatisticsContent>> compareLaunches(@PathVariable String projectName, @RequestParam(value="ids") Long[] ids, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getLaunchMessageHandler.getLaunchesComparisonInfo(this.projectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), ids);
    }

    @Transactional
    @PostMapping(value={"/merge"}, produces={"application/x.reportportal.launch.v2+json"})
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')||hasRole('ADMINISTRATOR')")
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Merge set of specified launches in common one", description="This operation merges a set of launches into a common one. The IDs of the launches to be merged should be provided in the 'launches' field of the request body.")
    public LaunchResource mergeLaunches(@PathVariable String projectName, @Parameter(description="Merge launches request body", required=true) @RequestBody @Validated MergeLaunchesRQ mergeLaunchesRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.mergeLaunchesHandler.mergeLaunches(this.projectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), user, mergeLaunchesRQ);
    }

    @Transactional
    @PostMapping(value={"/merge"})
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')||hasRole('ADMINISTRATOR')")
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Merge set of specified launches in common one", description="This operation merges a set of launches into a common one. The IDs of the launches to be merged should be provided in the 'launches' field of the request body.")
    @ApiResponse(responseCode="200", description="Successful response with dates in timestamp format. Response with dates in ISO-8601 format if the custom header 'Accept: application/x.reportportal.launch.v2+json' is used.", content={@Content(mediaType="application/json", schema=@Schema(implementation=LaunchResourceOld.class))})
    public LaunchResourceOld mergeLaunchesOldUuid(@PathVariable String projectName, @Parameter(description="Merge launches request body", required=true) @RequestBody @Validated MergeLaunchesRQ mergeLaunchesRQ, @AuthenticationPrincipal ReportPortalUser user) {
        LaunchResource launchResource = this.mergeLaunchesHandler.mergeLaunches(this.projectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), user, mergeLaunchesRQ);
        return this.launchConverter.TO_RESOURCE_OLD.apply(launchResource);
    }

    @Transactional
    @PostMapping(value={"/analyze"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Start launch auto-analyzer on demand")
    public OperationCompletionRS startLaunchAnalyzer(@PathVariable String projectName, @RequestBody @Validated AnalyzeLaunchRQ analyzeLaunchRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.updateLaunchHandler.startLaunchAnalyzer(analyzeLaunchRQ, this.projectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), user);
    }

    @PostMapping(value={"/cluster"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Create launch clusters")
    public OperationCompletionRS createClusters(@PathVariable String projectName, @RequestBody @Validated CreateClustersRQ createClustersRQ, @AuthenticationPrincipal ReportPortalUser user) {
        return this.updateLaunchHandler.createClusters(createClustersRQ, this.projectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), user);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/status"})
    @ResponseStatus(value=HttpStatus.OK)
    public Map<String, String> getStatuses(@PathVariable String projectName, @RequestParam(value="ids") Long[] ids, @AuthenticationPrincipal ReportPortalUser user) {
        return this.getLaunchMessageHandler.getStatuses(this.projectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), ids);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/{launchId}/report"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
    @Operation(summary="Export specified launch", description="Only following formats are supported: pdf (by default), xls, html.")
    public void getLaunchReport(@PathVariable String projectName, @PathVariable Long launchId, @Parameter(schema=@Schema(allowableValues={"pdf", "xls", "html"})) @RequestParam(value="view", required=false, defaultValue="pdf") String view, @AuthenticationPrincipal ReportPortalUser user, HttpServletResponse response) {
        ReportFormat format = this.getJasperHandler.getReportFormat(view);
        response.setContentType(format.getContentType());
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"RP_LAUNCH_%s_Report.%s\"", format.name(), format.getValue()));
        try (ServletOutputStream outputStream = response.getOutputStream();){
            this.getLaunchMessageHandler.exportLaunch(launchId, format, (OutputStream)outputStream, user);
        }
        catch (IOException e) {
            throw new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Unable to write data to the response."});
        }
    }

    @Transactional
    @DeleteMapping
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')||hasRole('ADMINISTRATOR')")
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Delete specified launches by ids")
    public DeleteBulkRS deleteLaunches(@PathVariable String projectName, @RequestParam(value="ids") List<Long> ids, @AuthenticationPrincipal ReportPortalUser user) {
        return this.deleteLaunchMessageHandler.deleteLaunches(ids, this.projectExtractor.extractProjectDetails(user, EntityUtils.normalizeId((String)projectName)), user);
    }
}

