/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.util.email.strategy;

import com.epam.ta.reportportal.util.email.MailServiceFactory;
import com.epam.ta.reportportal.util.email.strategy.AbstractEmailNotificationStrategy;
import java.util.Map;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class UserSelfDeletionNotificationStrategy
extends AbstractEmailNotificationStrategy {
    public UserSelfDeletionNotificationStrategy(MailServiceFactory mailServiceFactory, ThreadPoolTaskExecutor emailExecutorService) {
        super(mailServiceFactory, emailExecutorService);
    }

    @Override
    public void sendEmail(String recipient, Map<String, Object> params) {
        try {
            this.emailExecutorService.execute(() -> this.mailServiceFactory.getDefaultEmailService(true).sendAccountSelfDeletionNotification(recipient));
        }
        catch (Exception e) {
            LOGGER.warn("Unable to send email.", (Throwable)e);
        }
    }
}

