/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.util.email.strategy;

import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import java.util.Arrays;
import java.util.stream.Collectors;

public enum EmailTemplate {
    USER_EXPIRATION_NOTIFICATION("userExpirationNotification"),
    USER_DELETION_NOTIFICATION("userDeletionNotification"),
    USER_SELF_DELETION_NOTIFICATION("userSelfDeletionNotification");

    private final String name;

    private EmailTemplate(String name) {
        this.name = name;
    }

    public static EmailTemplate fromString(String type) {
        return Arrays.stream(EmailTemplate.values()).filter(it -> it.getName().equalsIgnoreCase(type)).findFirst().orElseThrow(() -> new ReportPortalException(ErrorType.INCORRECT_REQUEST, new Object[]{"Incorrect analyzer type. Allowed are: " + String.valueOf(Arrays.stream(EmailTemplate.values()).map(EmailTemplate::getName).collect(Collectors.toList()))}));
    }

    public String getName() {
        return this.name;
    }
}

