/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.reporting.async.producer;

import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.BinaryDataMetaInfo;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.configs.rabbit.DeserializablePair;
import com.epam.ta.reportportal.core.log.CreateLogHandler;
import com.epam.ta.reportportal.core.log.impl.SaveLogBinaryDataTaskAsync;
import com.epam.ta.reportportal.reporting.async.config.RequestType;
import com.epam.ta.reportportal.ws.reporting.EntryCreatedAsyncRS;
import com.epam.ta.reportportal.ws.reporting.SaveLogRQ;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.inject.Provider;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class LogProducer
implements CreateLogHandler {
    @Autowired
    private Provider<SaveLogBinaryDataTaskAsync> saveLogBinaryDataTask;
    @Autowired
    @Qualifier(value="saveLogsTaskExecutor")
    private TaskExecutor taskExecutor;
    @Autowired
    @Qualifier(value="rabbitTemplate")
    private AmqpTemplate amqpTemplate;

    @Override
    @Nonnull
    public EntryCreatedAsyncRS createLog(@Nonnull SaveLogRQ request, @Nullable MultipartFile file, ReportPortalUser.ProjectDetails projectDetails) {
        this.validate(request);
        if (!StringUtils.hasText((String)request.getUuid())) {
            request.setUuid(UUID.randomUUID().toString());
        }
        if (file != null) {
            CompletableFuture.supplyAsync(((SaveLogBinaryDataTaskAsync)this.saveLogBinaryDataTask.get()).withRequest(request).withFile(file).withProjectId(projectDetails.getProjectId()), (Executor)this.taskExecutor).thenAccept(metaInfo -> this.sendMessage(request, (BinaryDataMetaInfo)metaInfo, projectDetails.getProjectId()));
        } else {
            this.sendMessage(request, null, projectDetails.getProjectId());
        }
        EntryCreatedAsyncRS response = new EntryCreatedAsyncRS();
        response.setId(request.getUuid());
        return response;
    }

    public void sendMessage(SaveLogRQ request, BinaryDataMetaInfo metaInfo, Long projectId) {
        String launchUuid = Optional.ofNullable(request.getLaunchUuid()).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Launch UUID should not be null or empty."}));
        this.amqpTemplate.convertAndSend("e.reporting", "", DeserializablePair.of(request, metaInfo), message -> {
            Map headers = message.getMessageProperties().getHeaders();
            headers.put("hash-on", launchUuid);
            headers.put("requestType", RequestType.LOG);
            headers.put("projectId", projectId);
            headers.put("itemId", request.getItemUuid());
            return message;
        });
    }
}

