/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.reporting.async.producer;

import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.item.StartTestItemHandler;
import com.epam.ta.reportportal.reporting.async.config.RequestType;
import com.epam.ta.reportportal.ws.reporting.ItemCreatedRS;
import com.epam.ta.reportportal.ws.reporting.StartTestItemRQ;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ItemStartProducer
implements StartTestItemHandler {
    private final AmqpTemplate amqpTemplate;

    public ItemStartProducer(@Qualifier(value="rabbitTemplate") AmqpTemplate amqpTemplate) {
        this.amqpTemplate = amqpTemplate;
    }

    private static void provideItemUuid(StartTestItemRQ request) {
        if (!StringUtils.hasText((String)request.getUuid())) {
            request.setUuid(UUID.randomUUID().toString());
        }
    }

    @Override
    public ItemCreatedRS startRootItem(ReportPortalUser user, ReportPortalUser.ProjectDetails projectDetails, StartTestItemRQ request) {
        ItemStartProducer.provideItemUuid(request);
        this.amqpTemplate.convertAndSend("e.reporting", "", (Object)request, message -> {
            Map headers = message.getMessageProperties().getHeaders();
            headers.put("hash-on", Optional.ofNullable(request.getLaunchUuid()).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Launch UUID should not be null or empty."})));
            headers.put("requestType", RequestType.START_TEST);
            headers.put("username", user.getUsername());
            headers.put("projectName", projectDetails.getProjectName());
            headers.put("parentItemId", "");
            return message;
        });
        ItemCreatedRS response = new ItemCreatedRS();
        response.setId(request.getUuid());
        return response;
    }

    @Override
    public ItemCreatedRS startChildItem(ReportPortalUser user, ReportPortalUser.ProjectDetails projectDetails, StartTestItemRQ request, String parentId) {
        String launchUuid = Optional.ofNullable(request.getLaunchUuid()).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Launch UUID should not be null or empty."}));
        ItemStartProducer.provideItemUuid(request);
        this.amqpTemplate.convertAndSend("e.reporting", "", (Object)request, message -> {
            Map headers = message.getMessageProperties().getHeaders();
            headers.put("hash-on", launchUuid);
            headers.put("requestType", RequestType.START_TEST);
            headers.put("username", user.getUsername());
            headers.put("projectName", projectDetails.getProjectName());
            headers.put("parentItemId", parentId);
            return message;
        });
        ItemCreatedRS response = new ItemCreatedRS();
        response.setId(request.getUuid());
        return response;
    }
}

