/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.reporting.async.handler;

import com.epam.ta.reportportal.auth.basic.DatabaseUserDetailsService;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.launch.StartLaunchHandler;
import com.epam.ta.reportportal.reporting.async.handler.ReportingMessageHandler;
import com.epam.ta.reportportal.reporting.async.message.MessageRetriever;
import com.epam.ta.reportportal.util.ProjectExtractor;
import com.epam.ta.reportportal.ws.reporting.StartLaunchRQ;
import java.util.Map;
import java.util.Optional;
import org.springframework.amqp.core.Message;
import org.springframework.stereotype.Service;

@Service
public class LaunchStartMessageHandler
implements ReportingMessageHandler {
    private final MessageRetriever retriever;
    private final StartLaunchHandler startLaunchHandler;
    private final ProjectExtractor projectExtractor;
    private final DatabaseUserDetailsService userDetailsService;

    public LaunchStartMessageHandler(MessageRetriever retriever, StartLaunchHandler startLaunchHandler, ProjectExtractor projectExtractor, DatabaseUserDetailsService userDetailsService) {
        this.retriever = retriever;
        this.startLaunchHandler = startLaunchHandler;
        this.projectExtractor = projectExtractor;
        this.userDetailsService = userDetailsService;
    }

    @Override
    public void handleMessage(Message message) {
        Optional<StartLaunchRQ> startLaunchRQ = this.retriever.retrieveValid(message, StartLaunchRQ.class);
        Map headers = message.getMessageProperties().getHeaders();
        startLaunchRQ.ifPresent(rq -> {
            String projectName = (String)headers.get("projectName");
            String username = (String)headers.get("username");
            ReportPortalUser user = (ReportPortalUser)this.userDetailsService.loadUserByUsername(username);
            this.startLaunchHandler.startLaunch(user, this.projectExtractor.extractProjectDetails(user, projectName), (StartLaunchRQ)rq);
        });
    }
}

