/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.reporting.async.handler;

import com.epam.ta.reportportal.auth.basic.DatabaseUserDetailsService;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.launch.FinishLaunchHandler;
import com.epam.ta.reportportal.reporting.async.handler.ReportingMessageHandler;
import com.epam.ta.reportportal.reporting.async.message.MessageRetriever;
import com.epam.ta.reportportal.util.ProjectExtractor;
import com.epam.ta.reportportal.ws.reporting.FinishExecutionRQ;
import java.util.Map;
import java.util.Optional;
import org.springframework.amqp.core.Message;
import org.springframework.stereotype.Service;

@Service
public class LaunchFinishMessageHandler
implements ReportingMessageHandler {
    private final MessageRetriever retriever;
    private final FinishLaunchHandler finishLaunchHandler;
    private final ProjectExtractor projectExtractor;
    private final DatabaseUserDetailsService userDetailsService;

    public LaunchFinishMessageHandler(MessageRetriever retriever, FinishLaunchHandler finishLaunchHandler, ProjectExtractor projectExtractor, DatabaseUserDetailsService userDetailsService) {
        this.retriever = retriever;
        this.finishLaunchHandler = finishLaunchHandler;
        this.projectExtractor = projectExtractor;
        this.userDetailsService = userDetailsService;
    }

    @Override
    public void handleMessage(Message message) {
        Optional<FinishExecutionRQ> finishExecutionRQ = this.retriever.retrieveValid(message, FinishExecutionRQ.class);
        Map headers = message.getMessageProperties().getHeaders();
        finishExecutionRQ.ifPresent(rq -> {
            String username = (String)headers.get("username");
            String projectName = (String)headers.get("projectName");
            String launchId = (String)headers.get("launchId");
            String baseUrl = (String)headers.get("baseUrl");
            ReportPortalUser user = (ReportPortalUser)this.userDetailsService.loadUserByUsername(username);
            this.finishLaunchHandler.finishLaunch(launchId, (FinishExecutionRQ)rq, this.projectExtractor.extractProjectDetails(user, projectName), user, baseUrl);
        });
    }
}

