/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.reporting.async.exception;

import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.support.ListenerExecutionFailedException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.ErrorHandler;

@Component
public class ReportingErrorHandler
implements ErrorHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReportingErrorHandler.class);
    private static final List<ErrorType> RETRYABLE_ERROR_TYPES = Lists.newArrayList((Object[])new ErrorType[]{ErrorType.LAUNCH_NOT_FOUND, ErrorType.TEST_SUITE_NOT_FOUND, ErrorType.TEST_ITEM_NOT_FOUND});
    private final RabbitTemplate rabbitTemplate;
    private final String RETRY_COUNT_HEADER = "x-retry-count";
    @Value(value="${reporting.retry.max-count:20}")
    private Integer maxRetryCount;

    public ReportingErrorHandler(RabbitTemplate rabbitTemplate) {
        this.rabbitTemplate = rabbitTemplate;
    }

    public void handleError(Throwable t) {
        if (t instanceof ListenerExecutionFailedException) {
            ReportPortalException reportPortalException;
            ListenerExecutionFailedException executionFailedException = (ListenerExecutionFailedException)t;
            Message failedMessage = executionFailedException.getFailedMessage();
            failedMessage.getMessageProperties().getHeaders().put("exception", executionFailedException.getCause().getMessage());
            int retryCount = this.getRetryCount(failedMessage.getMessageProperties());
            if (retryCount > 0) {
                log.warn("Retrying reporting message. Attempt count is {}. Request Type: {}, Launch UUID: {} ", new Object[]{retryCount, failedMessage.getMessageProperties().getHeader("requestType"), failedMessage.getMessageProperties().getHeader("hash-on")});
            }
            if (this.checkRetryExceeded(retryCount)) {
                log.warn("Number of retries exceeded max {} retry count.", (Object)this.maxRetryCount);
                log.warn("Rejecting message to parking lot queue. Message: {}", (Object)new String(failedMessage.getBody()));
                this.rabbitTemplate.send("q.parkingLot.reporting", failedMessage);
                return;
            }
            Throwable throwable = executionFailedException.getCause();
            if (throwable instanceof ReportPortalException && RETRYABLE_ERROR_TYPES.contains((reportPortalException = (ReportPortalException)throwable).getErrorType())) {
                failedMessage.getMessageProperties().setHeader("x-retry-count", (Object)(retryCount + 1));
                this.rabbitTemplate.send("e.reporting.retry", this.getRetryTtlQueue(retryCount), failedMessage);
                return;
            }
            log.error("Message rejected to the parking lot queue: {}", (Object)new String(failedMessage.getBody()));
            this.rabbitTemplate.send("q.parkingLot.reporting", failedMessage);
        }
    }

    private String getRetryTtlQueue(int retryCount) {
        if (retryCount <= 5) {
            return "q.retry.reporting.ttl.ms";
        }
        if (retryCount <= 10) {
            return "q.retry.reporting.ttl.s";
        }
        return "q.retry.reporting.ttl.m";
    }

    private int getRetryCount(MessageProperties messageProperties) {
        return Optional.ofNullable(messageProperties.getHeader("x-retry-count")).map(it -> (Integer)it).orElse(0);
    }

    private boolean checkRetryExceeded(long retries) {
        return retries >= (long)this.maxRetryCount.intValue();
    }
}

