/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.model.dashboard;

import com.epam.ta.reportportal.model.Position;
import com.epam.ta.reportportal.model.Size;
import com.epam.ta.reportportal.ws.reporting.OwnedResource;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DashboardResource
extends OwnedResource {
    @NotNull
    @JsonProperty(value="id", required=true)
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED)
    private Long dashboardId;
    @NotBlank
    @jakarta.validation.constraints.Size(min=3, max=128)
    @JsonProperty(value="name", required=true)
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED)
    private @NotBlank @jakarta.validation.constraints.Size(min=3, max=128) String name;
    @JsonProperty(value="widgets")
    private List<WidgetObjectModel> widgets;

    public Long getDashboardId() {
        return this.dashboardId;
    }

    public void setDashboardId(Long dashboardId) {
        this.dashboardId = dashboardId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<WidgetObjectModel> getWidgets() {
        return this.widgets;
    }

    public void setWidgets(List<WidgetObjectModel> widgets) {
        this.widgets = widgets;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DashboardResource{");
        sb.append("dashboardId='").append(this.dashboardId).append('\'');
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", widgets=").append(this.widgets);
        sb.append('}');
        return sb.toString();
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class WidgetObjectModel {
        @JsonProperty(value="widgetName")
        private String name;
        @NotNull
        @JsonProperty(value="widgetId")
        private Long widgetId;
        @JsonProperty(value="widgetType")
        private String widgetType;
        @JsonProperty(value="widgetSize")
        private Size widgetSize = new Size();
        @JsonProperty(value="widgetPosition")
        private Position widgetPosition = new Position();
        @JsonProperty(value="widgetOptions")
        private Map<String, Object> widgetOptions;

        public WidgetObjectModel() {
        }

        public WidgetObjectModel(String name, Long widgetId, Size widgetSize, Position widgetPosition) {
            this.name = name;
            this.widgetId = widgetId;
            this.widgetSize = widgetSize;
            this.widgetPosition = widgetPosition;
        }

        public Long getWidgetId() {
            return this.widgetId;
        }

        public void setWidgetId(Long widgetId) {
            this.widgetId = widgetId;
        }

        public String getWidgetType() {
            return this.widgetType;
        }

        public void setWidgetType(String widgetType) {
            this.widgetType = widgetType;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Size getWidgetSize() {
            return this.widgetSize;
        }

        public void setWidgetSize(Size widgetSize) {
            this.widgetSize = widgetSize;
        }

        public Position getWidgetPosition() {
            return this.widgetPosition;
        }

        public void setWidgetPosition(Position widgetPosition) {
            this.widgetPosition = widgetPosition;
        }

        public Map<String, Object> getWidgetOptions() {
            return this.widgetOptions;
        }

        public void setWidgetOptions(Map<String, Object> widgetOptions) {
            this.widgetOptions = widgetOptions;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("WidgetObjectModel{");
            sb.append("name='").append(this.name).append('\'');
            sb.append(", widgetId=").append(this.widgetId);
            sb.append(", widgetType='").append(this.widgetType).append('\'');
            sb.append(", widgetSize=").append(this.widgetSize);
            sb.append(", widgetPosition=").append(this.widgetPosition);
            sb.append(", widgetOptions=").append(this.widgetOptions);
            sb.append('}');
            return sb.toString();
        }
    }
}

