/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.info;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.info.Info;
import org.springframework.boot.actuate.info.InfoContributor;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class JobsInfoContributor
implements InfoContributor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobsInfoContributor.class);
    private final RestTemplate restTemplate;
    @Value(value="${rp.jobs.baseUrl}")
    private String jobsBaseUrl;

    public JobsInfoContributor(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public void contribute(Info.Builder builder) {
        try {
            Map jobsInfoRs = (Map)this.restTemplate.getForObject(this.jobsBaseUrl + "/info", Map.class, new Object[0]);
            builder.withDetail("jobsInfo", (Object)jobsInfoRs).build();
        }
        catch (Exception e) {
            LOGGER.error("Jobs service was not found");
        }
    }
}

