/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.exception.rest;

import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.ta.reportportal.exception.message.ExceptionMessageBuilder;
import lombok.Generated;
import org.springframework.http.HttpStatus;

public class RestErrorDefinition<T extends Exception> {
    private final HttpStatus httpStatus;
    private final ErrorType error;
    private final ExceptionMessageBuilder<T> exceptionMessageBuilder;

    public RestErrorDefinition(HttpStatus httpStatus, ErrorType error, ExceptionMessageBuilder<T> exceptionMessageBuilder) {
        this.httpStatus = httpStatus;
        this.error = error;
        this.exceptionMessageBuilder = exceptionMessageBuilder;
    }

    public RestErrorDefinition(int httpStatus, ErrorType error, ExceptionMessageBuilder<T> exceptionMessageBuilder) {
        this(HttpStatus.valueOf((int)httpStatus), error, exceptionMessageBuilder);
    }

    public String getExceptionMessage(T e) {
        return this.exceptionMessageBuilder.buildMessage(e);
    }

    public ExceptionMessageBuilder<? extends Exception> getExceptionMessageBuilder() {
        return this.exceptionMessageBuilder;
    }

    @Generated
    public HttpStatus getHttpStatus() {
        return this.httpStatus;
    }

    @Generated
    public ErrorType getError() {
        return this.error;
    }
}

