/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.exception.rest;

import com.epam.reportportal.rules.exception.ErrorRS;
import com.epam.reportportal.rules.exception.ErrorType;
import org.springframework.http.HttpStatus;

public record RestError(HttpStatus httpStatus, ErrorRS errorRs) {

    public static class Builder {
        private HttpStatus status;
        private ErrorType error;
        private String message;
        private String stackTrace;

        public Builder setStatus(HttpStatus status) {
            this.status = status;
            return this;
        }

        public Builder setError(ErrorType error) {
            this.error = error;
            return this;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder setStackTrace(String stackTrace) {
            this.stackTrace = stackTrace;
            return this;
        }

        public RestError build() {
            ErrorRS errorRs = new ErrorRS();
            errorRs.setMessage(this.message);
            errorRs.setStackTrace(this.stackTrace);
            errorRs.setErrorType(this.error);
            return new RestError(this.status, errorRs);
        }
    }
}

