/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.exception.forwarding;

import com.epam.ta.reportportal.exception.forwarding.ResponseForwardingException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class ClientResponseForwardingExceptionHandler
implements Ordered {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientResponseForwardingExceptionHandler.class);
    private int order;

    public ResponseEntity<String> resolveException(Exception ex) {
        try {
            ResponseForwardingException forwardingException = (ResponseForwardingException)ex;
            String body = new String(forwardingException.getBody(), StandardCharsets.UTF_8);
            return ResponseEntity.status((HttpStatusCode)forwardingException.getStatus()).contentType(Objects.requireNonNull(forwardingException.getHeaders().getContentType())).body((Object)body);
        }
        catch (Exception e) {
            LOGGER.error("Cannot forward exception", (Throwable)e);
            return null;
        }
    }

    public int getOrder() {
        return this.order;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }
}

