/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.demodata.service.generator;

import com.epam.ta.reportportal.demodata.model.DemoItemMetadata;
import com.epam.ta.reportportal.demodata.model.RootMetaData;
import com.epam.ta.reportportal.demodata.service.DemoDataTestItemService;
import com.epam.ta.reportportal.demodata.service.DemoLogsService;
import com.epam.ta.reportportal.demodata.service.generator.DefaultSuiteGenerator;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import java.util.stream.IntStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SuiteWithRetriesGenerator
extends DefaultSuiteGenerator {
    private static final int RETRIES_COUNT = 3;

    @Autowired
    public SuiteWithRetriesGenerator(DemoDataTestItemService demoDataTestItemService, DemoLogsService demoLogsService) {
        super(demoDataTestItemService, demoLogsService);
    }

    @Override
    protected void createStep(DemoItemMetadata stepMetaData, RootMetaData rootMetaData) {
        super.createStep(stepMetaData, rootMetaData);
        if (stepMetaData.getStatus() != StatusEnum.PASSED) {
            this.generateRetries(stepMetaData, rootMetaData);
        }
    }

    private void generateRetries(DemoItemMetadata metadata, RootMetaData rootMetaData) {
        IntStream.range(0, 3).forEach(i -> {
            DemoItemMetadata retryMetaData = this.getMetadata(metadata.getName(), metadata.getType(), metadata.getStatus(), metadata.getParentId()).withIssue(metadata.getIssue()).withRetry(true);
            super.createStep(retryMetaData, rootMetaData);
        });
    }
}

