/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.demodata.service;

import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.binary.AttachmentBinaryDataService;
import com.epam.ta.reportportal.core.log.LogService;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.LogRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.demodata.service.Attachment;
import com.epam.ta.reportportal.demodata.service.ContentUtils;
import com.epam.ta.reportportal.entity.attachment.AttachmentMetaInfo;
import com.epam.ta.reportportal.entity.enums.LogLevel;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.log.Log;
import com.epam.ta.reportportal.entity.log.LogFull;
import com.epam.ta.reportportal.util.MultipartFileUtils;
import com.epam.ta.reportportal.ws.converter.converters.LogConverter;
import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.SplittableRandom;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DemoLogsService {
    private final int attachmentProbability;
    private final SplittableRandom random;
    private final LogRepository logRepository;
    private final LaunchRepository launchRepository;
    private final TestItemRepository testItemRepository;
    private final LogService logService;
    private final AttachmentBinaryDataService attachmentBinaryDataService;

    public DemoLogsService(@Value(value="${rp.environment.variable.demo.attachment.probability}") int attachmentProbability, LogRepository logRepository, LaunchRepository launchRepository, TestItemRepository testItemRepository, LogService logService, AttachmentBinaryDataService attachmentBinaryDataService) {
        this.attachmentProbability = attachmentProbability;
        this.logService = logService;
        this.random = new SplittableRandom();
        this.logRepository = logRepository;
        this.launchRepository = launchRepository;
        this.testItemRepository = testItemRepository;
        this.attachmentBinaryDataService = attachmentBinaryDataService;
    }

    public List<Log> generateLaunchLogs(int count, String launchUUid, StatusEnum status) {
        Launch launch = (Launch)this.launchRepository.findByUuid(launchUUid).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{launchUUid}));
        List<LogFull> logFulls = IntStream.range(0, count).mapToObj(it -> this.getLogFull(launch, ContentUtils.getLogMessage(), this.infoLevel())).collect(Collectors.toList());
        if (StatusEnum.FAILED.equals((Object)status)) {
            List<String> errors = ContentUtils.getErrorLogs();
            logFulls.addAll(errors.stream().map(msg -> this.getLogFull(launch, (String)msg, this.errorLevel())).collect(Collectors.toList()));
        }
        List<Log> logs = logFulls.stream().map(LogConverter.LOG_FULL_TO_LOG).collect(Collectors.toList());
        this.logRepository.saveAll(logs);
        this.fillIdByUuid(logFulls, logs);
        this.logService.saveLogMessageList(logFulls, launch.getId());
        return logs;
    }

    private LogFull getLogFull(Launch launch, String message, LogLevel logLevel) {
        LogFull logFull = new LogFull();
        logFull.setLogLevel(Integer.valueOf(logLevel.toInt()));
        logFull.setLogTime(Instant.now());
        logFull.setLaunch(launch);
        logFull.setProjectId(launch.getProjectId());
        logFull.setLogMessage(message);
        logFull.setUuid(UUID.randomUUID().toString());
        return logFull;
    }

    public List<Log> generateItemLogs(int count, Long projectId, String itemUuid, StatusEnum status) {
        TestItem testItem = (TestItem)this.testItemRepository.findByUuid(itemUuid).orElseThrow(() -> new ReportPortalException(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{itemUuid}));
        List<LogFull> logFulls = IntStream.range(0, count).mapToObj(it -> this.getLogFull(projectId, testItem, this.infoLevel(), ContentUtils.getLogMessage())).collect(Collectors.toList());
        if (StatusEnum.FAILED.equals((Object)status)) {
            List<String> errors = ContentUtils.getErrorLogs();
            logFulls.addAll(errors.stream().map(msg -> this.getLogFull(projectId, testItem, this.errorLevel(), (String)msg)).collect(Collectors.toList()));
        }
        List<Log> logs = logFulls.stream().map(LogConverter.LOG_FULL_TO_LOG).collect(Collectors.toList());
        this.logRepository.saveAll(logs);
        this.fillIdByUuid(logFulls, logs);
        this.logService.saveLogMessageList(logFulls, testItem.getLaunchId());
        return logs;
    }

    private LogFull getLogFull(Long projectId, TestItem testItem, LogLevel logLevel, String logMessage) {
        LogFull logFull = new LogFull();
        logFull.setLogLevel(Integer.valueOf(logLevel.toInt()));
        logFull.setLogTime(Instant.now());
        logFull.setTestItem(testItem);
        logFull.setProjectId(projectId);
        logFull.setLogMessage(logMessage);
        logFull.setUuid(UUID.randomUUID().toString());
        return logFull;
    }

    private void fillIdByUuid(List<LogFull> logFulls, List<Log> logs) {
        if (CollectionUtils.isNotEmpty(logFulls) && CollectionUtils.isNotEmpty(logs)) {
            HashMap<String, Long> logIdsMap = new HashMap<String, Long>(logs.size());
            for (Log log : logs) {
                logIdsMap.put(log.getUuid(), log.getId());
            }
            for (LogFull logFull : logFulls) {
                logFull.setId((Long)logIdsMap.get(logFull.getUuid()));
            }
        }
    }

    public void attachFiles(List<Log> logs, Long projectId, String launchUuid) {
        Launch launch = (Launch)this.launchRepository.findByUuid(launchUuid).orElseThrow(() -> new ReportPortalException(ErrorType.UNCLASSIFIED_REPORT_PORTAL_ERROR, new Object[0]));
        this.createAttachments(logs, projectId, launch.getId(), null, launchUuid);
    }

    public void attachFiles(List<Log> logs, Long projectId, String itemUuid, String launchUuid) {
        Launch launch = (Launch)this.launchRepository.findByUuid(launchUuid).orElseThrow(() -> new ReportPortalException(ErrorType.UNCLASSIFIED_REPORT_PORTAL_ERROR, new Object[0]));
        TestItem item = (TestItem)this.testItemRepository.findByUuid(itemUuid).orElseThrow(() -> new ReportPortalException(ErrorType.UNCLASSIFIED_REPORT_PORTAL_ERROR, new Object[0]));
        this.createAttachments(logs, projectId, launch.getId(), item.getItemId(), launchUuid);
    }

    private void createAttachments(List<Log> logs, Long projectId, Long launchId, Long itemId, String launchUuid) {
        BooleanHolder binaryDataAttached = new BooleanHolder();
        logs.forEach(it -> {
            if (LogLevel.ERROR.toInt() >= it.getLogLevel()) {
                if (ContentUtils.getWithProbability(this.attachmentProbability)) {
                    this.createAttachment(projectId, itemId, launchId, (Log)it, launchUuid);
                }
            } else if (!binaryDataAttached.getValue() && ContentUtils.getWithProbability(this.attachmentProbability)) {
                this.createAttachment(projectId, itemId, launchId, (Log)it, launchUuid);
                binaryDataAttached.setValue(true);
            }
        });
    }

    private void createAttachment(Long projectId, Long testItemId, Long launchId, Log it, String launchUuid) {
        Attachment attachment = Attachment.values()[this.random.nextInt(Attachment.values().length)];
        try {
            this.attachmentBinaryDataService.saveFileAndAttachToLog(MultipartFileUtils.getMultipartFile(attachment.getResource().getPath()), AttachmentMetaInfo.builder().withProjectId(projectId).withLaunchId(launchId).withItemId(testItemId).withLogId(it.getId()).withLaunchUuid(launchUuid).withLogUuid(it.getUuid()).withFileName(attachment.getName()).withCreationDate(Instant.now()).build());
        }
        catch (IOException e) {
            throw new ReportPortalException(ErrorType.UNCLASSIFIED_REPORT_PORTAL_ERROR, new Object[]{"Error generating demo data."});
        }
    }

    private LogLevel infoLevel() {
        int i = this.random.nextInt(50);
        if (i < 10) {
            return LogLevel.DEBUG;
        }
        if (i < 20) {
            return LogLevel.WARN;
        }
        if (i < 30) {
            return LogLevel.TRACE;
        }
        return LogLevel.INFO;
    }

    private LogLevel errorLevel() {
        return this.random.nextBoolean() ? LogLevel.ERROR : LogLevel.FATAL;
    }

    private static class BooleanHolder {
        private boolean value = false;

        BooleanHolder() {
        }

        public boolean getValue() {
            return this.value;
        }

        public void setValue(boolean value) {
            this.value = value;
        }
    }
}

