/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.demodata.service;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.item.FinishTestItemHandler;
import com.epam.ta.reportportal.core.item.StartTestItemHandler;
import com.epam.ta.reportportal.demodata.model.DemoItemMetadata;
import com.epam.ta.reportportal.demodata.model.RootMetaData;
import com.epam.ta.reportportal.demodata.service.ContentUtils;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.enums.TestItemIssueGroup;
import com.epam.ta.reportportal.entity.enums.TestItemTypeEnum;
import com.epam.ta.reportportal.ws.reporting.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.reporting.StartTestItemRQ;
import java.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DemoDataTestItemService {
    private final StartTestItemHandler startTestItemHandler;
    private final FinishTestItemHandler finishTestItemHandler;

    @Autowired
    public DemoDataTestItemService(StartTestItemHandler startTestItemHandler, FinishTestItemHandler finishTestItemHandler) {
        this.startTestItemHandler = startTestItemHandler;
        this.finishTestItemHandler = finishTestItemHandler;
    }

    @Transactional
    public String startRootItem(DemoItemMetadata metadata, RootMetaData rootMetaData) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setName(metadata.getName());
        rq.setCodeRef("com.epam.ta.reportportal.demodata." + metadata.getName());
        rq.setLaunchUuid(rootMetaData.getLaunchUuid());
        rq.setStartTime(Instant.now());
        rq.setType(metadata.getType().name());
        if (metadata.getType().sameLevel(TestItemTypeEnum.SUITE)) {
            rq.setAttributes(ContentUtils.getAttributesInRange(3));
            rq.setDescription(ContentUtils.getSuiteDescription());
        }
        return this.startTestItemHandler.startRootItem(rootMetaData.getUser(), rootMetaData.getProjectDetails(), rq).getId();
    }

    @Transactional
    public void finishRootItem(String rootItemId, ReportPortalUser user, ReportPortalUser.ProjectDetails projectDetails) {
        FinishTestItemRQ rq = new FinishTestItemRQ();
        rq.setEndTime(Instant.now());
        this.finishTestItemHandler.finishTestItem(user, projectDetails, rootItemId, rq);
    }

    @Transactional
    public String startTestItem(DemoItemMetadata metadata, RootMetaData rootMetaData) {
        StartTestItemRQ rq = new StartTestItemRQ();
        if (this.hasChildren(metadata.getType())) {
            rq.setAttributes(ContentUtils.getAttributesInRange(3));
            rq.setDescription(ContentUtils.getTestDescription());
        } else {
            rq.setAttributes(ContentUtils.getAttributesInRange(3));
            rq.setDescription(ContentUtils.getStepDescription());
        }
        rq.setHasStats(!metadata.isNested());
        rq.setCodeRef("com.epam.ta.reportportal.demodata." + metadata.getName());
        rq.setRetry(Boolean.valueOf(metadata.isRetry()));
        rq.setLaunchUuid(rootMetaData.getLaunchUuid());
        rq.setStartTime(Instant.now());
        rq.setName(metadata.getName());
        rq.setType(metadata.getType().name());
        return this.startTestItemHandler.startChildItem(rootMetaData.getUser(), rootMetaData.getProjectDetails(), rq, metadata.getParentId()).getId();
    }

    @Transactional
    public void finishTestItem(String testItemId, StatusEnum status, RootMetaData rootMetaData) {
        FinishTestItemRQ rq = new FinishTestItemRQ();
        rq.setEndTime(Instant.now());
        rq.setStatus(status.name());
        this.finishTestItemHandler.finishTestItem(rootMetaData.getUser(), rootMetaData.getProjectDetails(), testItemId, rq);
    }

    @Transactional
    public void finishTestItem(String testItemId, StatusEnum status, RootMetaData rootMetaData, String issue) {
        FinishTestItemRQ rq = new FinishTestItemRQ();
        rq.setEndTime(Instant.now());
        rq.setStatus(status.name());
        TestItemIssueGroup.fromValue((String)issue).ifPresent(group -> rq.setIssue(ContentUtils.getIssue(group)));
        this.finishTestItemHandler.finishTestItem(rootMetaData.getUser(), rootMetaData.getProjectDetails(), testItemId, rq);
    }

    private boolean hasChildren(TestItemTypeEnum testItemType) {
        return testItemType == TestItemTypeEnum.TEST || testItemType == TestItemTypeEnum.SUITE;
    }
}

