/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.demodata.service;

import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.events.activity.LaunchFinishedEvent;
import com.epam.ta.reportportal.core.launch.attribute.LaunchAttributeHandlerService;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.demodata.service.ContentUtils;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.user.User;
import com.epam.ta.reportportal.ws.converter.builders.LaunchBuilder;
import com.epam.ta.reportportal.ws.reporting.ItemAttributesRQ;
import com.epam.ta.reportportal.ws.reporting.Mode;
import com.epam.ta.reportportal.ws.reporting.StartLaunchRQ;
import com.google.common.collect.Sets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Random;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DemoDataLaunchService {
    private final String[] platformValues = new String[]{"linux", "windows", "macos", "ios", "android", "windows mobile", "ubuntu", "mint", "arch", "windows 10", "windows 7", "windows server", "debian", "alpine"};
    private final LaunchRepository launchRepository;
    private final TestItemRepository testItemRepository;
    private final ApplicationEventPublisher eventPublisher;
    private final LaunchAttributeHandlerService launchAttributeHandlerService;

    @Autowired
    public DemoDataLaunchService(LaunchRepository launchRepository, TestItemRepository testItemRepository, ApplicationEventPublisher eventPublisher, LaunchAttributeHandlerService launchAttributeHandlerService) {
        this.launchRepository = launchRepository;
        this.testItemRepository = testItemRepository;
        this.eventPublisher = eventPublisher;
        this.launchAttributeHandlerService = launchAttributeHandlerService;
    }

    @Transactional
    public Launch startLaunch(String name, User user, ReportPortalUser.ProjectDetails projectDetails) {
        StartLaunchRQ rq = new StartLaunchRQ();
        rq.setMode(Mode.DEFAULT);
        rq.setDescription(ContentUtils.getLaunchDescription());
        LocalDateTime now = LocalDateTime.now();
        rq.setName(name);
        rq.setStartTime(Instant.now());
        rq.setUuid(UUID.randomUUID().toString());
        HashSet attributes = Sets.newHashSet((Object[])new ItemAttributesRQ[]{new ItemAttributesRQ("platform", this.platformValues[new Random().nextInt(this.platformValues.length)]), new ItemAttributesRQ(null, "demo"), new ItemAttributesRQ("build", "3." + now.getDayOfMonth() + "." + now.getHour() + "." + now.getMinute() + "." + now.getSecond())});
        Launch launch = new LaunchBuilder().addStartRQ(rq).addAttributes(attributes).addProject(projectDetails.getProjectId()).get();
        this.launchAttributeHandlerService.handleLaunchStart(launch);
        launch.setUserId(user.getId());
        this.launchRepository.save((Object)launch);
        this.launchRepository.refresh((Object)launch);
        return launch;
    }

    @Transactional
    public void finishLaunch(String launchId) {
        Launch launch = (Launch)this.launchRepository.findByUuid(launchId).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{launchId}));
        if (this.testItemRepository.hasItemsInStatusByLaunch(launch.getId(), new StatusEnum[]{StatusEnum.IN_PROGRESS}).booleanValue()) {
            this.testItemRepository.interruptInProgressItems(launch.getId());
        }
        launch = new LaunchBuilder(launch).addEndTime(Instant.now()).get();
        StatusEnum fromStatisticsStatus = StatusEnum.PASSED;
        if (this.launchRepository.hasRootItemsWithStatusNotEqual(launch.getId(), new String[]{StatusEnum.PASSED.name(), StatusEnum.INFO.name(), StatusEnum.WARN.name()})) {
            fromStatisticsStatus = StatusEnum.FAILED;
        }
        launch.setStatus(fromStatisticsStatus);
        this.launchRepository.save((Object)launch);
        this.eventPublisher.publishEvent((Object)new LaunchFinishedEvent(launch));
    }
}

