/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.util;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.entity.widget.WidgetOptions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.BooleanUtils;

public final class WidgetOptionUtil {
    private WidgetOptionUtil() {
    }

    @Nullable
    public static String getValueByKey(String key, WidgetOptions widgetOptions) {
        Optional value = Optional.ofNullable(widgetOptions).flatMap(wo -> Optional.ofNullable(wo.getOptions()).map(options -> options.get(key)));
        value.ifPresent(v -> BusinessRule.expect((Object)v, String.class::isInstance).verify(ErrorType.OBJECT_RETRIEVAL_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Wrong widget option value type for key = '{}'. String expected.", (Object[])new Object[]{key})}));
        return value.orElse(null);
    }

    public static <K, V> Map<K, V> getMapByKey(String key, WidgetOptions widgetOptions) {
        Optional value = Optional.ofNullable(widgetOptions).flatMap(wo -> Optional.ofNullable(wo.getOptions()).map(options -> options.get(key)));
        value.ifPresent(v -> BusinessRule.expect((Object)v, Map.class::isInstance).verify(ErrorType.OBJECT_RETRIEVAL_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Wrong widget option value type for key = '{}'. Map expected.", (Object[])new Object[]{key})}));
        return (Map)value.orElseGet(Collections::emptyMap);
    }

    public static boolean getBooleanByKey(String key, WidgetOptions widgetOptions) {
        return Optional.ofNullable(widgetOptions).map(wo -> MapUtils.isNotEmpty((Map)wo.getOptions()) && Optional.ofNullable(wo.getOptions().get(key)).map(v -> BooleanUtils.toBoolean((String)String.valueOf(v))).orElse(false) != false).orElse(false);
    }

    public static boolean isBooleanPresent(String key, WidgetOptions widgetOptions) {
        return Optional.ofNullable(widgetOptions).map(wo -> MapUtils.isNotEmpty((Map)wo.getOptions()) && Optional.ofNullable(wo.getOptions().get(key)).map(String::valueOf).map(BooleanUtils::toBooleanObject).isPresent()).orElse(false);
    }

    public static Optional<Integer> getIntegerByKey(String key, WidgetOptions widgetOptions) {
        return Optional.ofNullable(widgetOptions).flatMap(wo -> Optional.ofNullable(wo.getOptions()).map(options -> options.get(key))).map(value -> {
            try {
                return Integer.parseInt(String.valueOf(value));
            }
            catch (NumberFormatException ex) {
                throw new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Error during parsing integer value of key = '{}'", (Object[])new Object[]{key}).get()});
            }
        });
    }

    public static <T> List<T> getListByKey(String key, WidgetOptions widgetOptions) {
        Optional value = Optional.ofNullable(widgetOptions).flatMap(wo -> Optional.ofNullable(wo.getOptions()).map(options -> options.get(key)));
        value.ifPresent(v -> BusinessRule.expect((Object)v, List.class::isInstance).verify(ErrorType.OBJECT_RETRIEVAL_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Wrong widget option value type for key = '{}'. List expected.", (Object[])new Object[]{key})}));
        return value.orElse(Collections.emptyList());
    }
}

