/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.impl;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.Condition;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.ProjectFilter;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.WidgetUpdatedEvent;
import com.epam.ta.reportportal.core.widget.UpdateWidgetHandler;
import com.epam.ta.reportportal.core.widget.content.updater.validator.WidgetValidator;
import com.epam.ta.reportportal.dao.UserFilterRepository;
import com.epam.ta.reportportal.dao.WidgetRepository;
import com.epam.ta.reportportal.entity.filter.UserFilter;
import com.epam.ta.reportportal.entity.widget.Widget;
import com.epam.ta.reportportal.model.activity.WidgetActivityResource;
import com.epam.ta.reportportal.model.widget.WidgetRQ;
import com.epam.ta.reportportal.ws.converter.builders.WidgetBuilder;
import com.epam.ta.reportportal.ws.converter.converters.WidgetConverter;
import com.epam.ta.reportportal.ws.reporting.OperationCompletionRS;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class UpdateWidgetHandlerImpl
implements UpdateWidgetHandler {
    private final WidgetRepository widgetRepository;
    private final UserFilterRepository filterRepository;
    private final MessageBus messageBus;
    private final ObjectMapper objectMapper;
    private final WidgetValidator widgetContentFieldsValidator;

    @Autowired
    public UpdateWidgetHandlerImpl(WidgetRepository widgetRepository, UserFilterRepository filterRepository, MessageBus messageBus, ObjectMapper objectMapper, WidgetValidator widgetContentFieldsValidator) {
        this.widgetRepository = widgetRepository;
        this.filterRepository = filterRepository;
        this.messageBus = messageBus;
        this.objectMapper = objectMapper;
        this.widgetContentFieldsValidator = widgetContentFieldsValidator;
    }

    @Override
    public OperationCompletionRS updateWidget(Long widgetId, WidgetRQ updateRQ, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        Widget widget = (Widget)this.widgetRepository.findByIdAndProjectId(widgetId, projectDetails.getProjectId()).orElseThrow(() -> new ReportPortalException(ErrorType.WIDGET_NOT_FOUND_IN_PROJECT, new Object[]{widgetId, projectDetails.getProjectName()}));
        this.widgetContentFieldsValidator.validate(widget);
        if (!widget.getName().equals(updateRQ.getName())) {
            BusinessRule.expect((Object)this.widgetRepository.existsByNameAndOwnerAndProjectId(updateRQ.getName(), user.getUsername(), projectDetails.getProjectId()), BooleanUtils::isFalse).verify(ErrorType.RESOURCE_ALREADY_EXISTS, new Object[]{updateRQ.getName()});
        }
        WidgetActivityResource before = WidgetConverter.TO_ACTIVITY_RESOURCE.apply(widget);
        List<UserFilter> userFilter = this.getUserFilters(updateRQ.getFilterIds(), projectDetails.getProjectId());
        String widgetOptionsBefore = this.parseWidgetOptions(widget);
        widget = new WidgetBuilder(widget).addWidgetRq(updateRQ).addFilters(userFilter).get();
        this.widgetRepository.save((Object)widget);
        this.messageBus.publishActivity(new WidgetUpdatedEvent(before, WidgetConverter.TO_ACTIVITY_RESOURCE.apply(widget), widgetOptionsBefore, this.parseWidgetOptions(widget), user.getUserId(), user.getUsername()));
        return new OperationCompletionRS("Widget with ID = '" + widget.getId() + "' successfully updated.");
    }

    private List<UserFilter> getUserFilters(List<Long> filterIds, Long projectId) {
        if (CollectionUtils.isNotEmpty(filterIds)) {
            Filter defaultFilter = new Filter(UserFilter.class, Condition.IN, false, filterIds.stream().map(String::valueOf).collect(Collectors.joining(",")), "id");
            return this.filterRepository.findByFilter((Queryable)ProjectFilter.of((Queryable)defaultFilter, (Long)projectId), Pageable.unpaged()).getContent();
        }
        return Collections.emptyList();
    }

    private String parseWidgetOptions(Widget widget) {
        try {
            return this.objectMapper.writeValueAsString((Object)widget.getWidgetOptions());
        }
        catch (JsonProcessingException e) {
            throw new ReportPortalException(ErrorType.INCORRECT_REQUEST, new Object[]{Suppliers.formattedSupplier((String)"Error during parsing new widget options of widget with id = ", (Object[])new Object[]{widget.getId()})});
        }
    }
}

