/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.impl;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.events.MessageBus;
import com.epam.ta.reportportal.core.events.activity.WidgetCreatedEvent;
import com.epam.ta.reportportal.core.filter.UpdateUserFilterHandler;
import com.epam.ta.reportportal.core.widget.CreateWidgetHandler;
import com.epam.ta.reportportal.core.widget.content.updater.WidgetPostProcessor;
import com.epam.ta.reportportal.core.widget.content.updater.validator.WidgetValidator;
import com.epam.ta.reportportal.dao.UserFilterRepository;
import com.epam.ta.reportportal.dao.WidgetRepository;
import com.epam.ta.reportportal.entity.filter.UserFilter;
import com.epam.ta.reportportal.entity.widget.Widget;
import com.epam.ta.reportportal.model.EntryCreatedRS;
import com.epam.ta.reportportal.model.widget.WidgetRQ;
import com.epam.ta.reportportal.ws.converter.builders.WidgetBuilder;
import com.epam.ta.reportportal.ws.converter.converters.WidgetConverter;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CreateWidgetHandlerImpl
implements CreateWidgetHandler {
    private final WidgetRepository widgetRepository;
    private final UserFilterRepository filterRepository;
    private final MessageBus messageBus;
    private final UpdateUserFilterHandler updateUserFilterHandler;
    private final List<WidgetPostProcessor> widgetPostProcessors;
    private final WidgetValidator widgetContentFieldsValidator;

    @Autowired
    public CreateWidgetHandlerImpl(WidgetRepository widgetRepository, UserFilterRepository filterRepository, MessageBus messageBus, UpdateUserFilterHandler updateUserFilterHandler, List<WidgetPostProcessor> widgetPostProcessors, WidgetValidator widgetContentFieldsValidator) {
        this.widgetRepository = widgetRepository;
        this.filterRepository = filterRepository;
        this.messageBus = messageBus;
        this.updateUserFilterHandler = updateUserFilterHandler;
        this.widgetPostProcessors = widgetPostProcessors;
        this.widgetContentFieldsValidator = widgetContentFieldsValidator;
    }

    @Override
    public EntryCreatedRS createWidget(WidgetRQ createWidgetRQ, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        List<UserFilter> userFilter = this.getUserFilters(createWidgetRQ.getFilterIds(), projectDetails.getProjectId(), user.getUsername());
        Widget widget = new WidgetBuilder().addWidgetRq(createWidgetRQ).addProject(projectDetails.getProjectId()).addFilters(userFilter).addOwner(user.getUsername()).get();
        this.widgetContentFieldsValidator.validate(widget);
        this.widgetPostProcessors.stream().filter(widgetPostProcessor -> widgetPostProcessor.supports(widget)).forEach(widgetPostProcessor -> widgetPostProcessor.postProcess(widget));
        this.widgetRepository.save((Object)widget);
        this.messageBus.publishActivity(new WidgetCreatedEvent(WidgetConverter.TO_ACTIVITY_RESOURCE.apply(widget), user.getUserId(), user.getUsername()));
        return new EntryCreatedRS(widget.getId());
    }

    private List<UserFilter> getUserFilters(List<Long> filterIds, Long projectId, String username) {
        if (CollectionUtils.isNotEmpty(filterIds)) {
            List userFilters = this.filterRepository.findAllByIdInAndProjectId(filterIds, projectId);
            BusinessRule.expect((Object)userFilters, (Predicate)Predicates.not(List::isEmpty)).verify(ErrorType.USER_FILTER_NOT_FOUND, new Object[]{filterIds, projectId, username});
            return userFilters;
        }
        return Collections.emptyList();
    }
}

