/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content.updater.validator;

import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.core.widget.content.BuildFilterStrategy;
import com.epam.ta.reportportal.core.widget.content.updater.validator.MultilevelValidatorStrategy;
import com.epam.ta.reportportal.core.widget.content.updater.validator.WidgetValidator;
import com.epam.ta.reportportal.core.widget.content.updater.validator.WidgetValidatorStrategy;
import com.epam.ta.reportportal.entity.widget.Widget;
import com.epam.ta.reportportal.entity.widget.WidgetType;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="widgetContentFieldsValidator")
public class WidgetContentFieldsValidator
implements WidgetValidator {
    private Map<WidgetType, BuildFilterStrategy> buildFilterStrategyMapping;
    private Map<WidgetType, WidgetValidatorStrategy> widgetValidatorLoader;
    private Map<WidgetType, MultilevelValidatorStrategy> multilevelValidatorLoader;

    @Autowired
    @Qualifier(value="buildFilterStrategy")
    public void setBuildFilterStrategy(Map<WidgetType, BuildFilterStrategy> buildFilterStrategyMapping) {
        this.buildFilterStrategyMapping = buildFilterStrategyMapping;
    }

    @Autowired
    @Qualifier(value="widgetValidatorLoader")
    public void setWidgetValidatorLoader(Map<WidgetType, WidgetValidatorStrategy> widgetValidatorLoader) {
        this.widgetValidatorLoader = widgetValidatorLoader;
    }

    @Autowired
    @Qualifier(value="multilevelValidatorLoader")
    public void setMultilevelValidatorLoader(Map<WidgetType, MultilevelValidatorStrategy> multilevelValidatorLoader) {
        this.multilevelValidatorLoader = multilevelValidatorLoader;
    }

    @Override
    public void validate(Widget widget) {
        WidgetType widgetType = (WidgetType)WidgetType.findByName((String)widget.getWidgetType()).orElseThrow(() -> new ReportPortalException(ErrorType.INCORRECT_REQUEST, new Object[]{Suppliers.formattedSupplier((String)"Unsupported widget type '{}'", (Object[])new Object[]{widget.getWidgetType()})}));
        if (widgetType.isSupportMultilevelStructure()) {
            this.multilevelValidatorLoader.get(widgetType).validate(Lists.newArrayList((Iterable)widget.getContentFields()), this.buildFilterStrategyMapping.get(widgetType).buildFilter(widget), widget.getWidgetOptions(), null, null, widget.getItemsCount());
        } else {
            this.widgetValidatorLoader.get(widgetType).validate(Lists.newArrayList((Iterable)Optional.ofNullable(widget.getContentFields()).orElse(Collections.emptySet())), this.buildFilterStrategyMapping.get(widgetType).buildFilter(widget), widget.getWidgetOptions(), widget.getItemsCount());
        }
    }
}

