/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content.updater.validator;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.core.widget.content.updater.validator.MultilevelValidatorStrategy;
import com.epam.ta.reportportal.core.widget.util.WidgetOptionUtil;
import com.epam.ta.reportportal.entity.widget.WidgetOptions;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class ComponentHealthCheckContentValidator
implements MultilevelValidatorStrategy {
    public static final Integer MAX_LEVEL_NUMBER = 10;

    @Override
    public void validate(List<String> contentFields, Map<Filter, Sort> filterSortMapping, WidgetOptions widgetOptions, String[] attributes, Map<String, String> params, int limit) {
        this.validateWidgetOptions(widgetOptions);
        List<String> attributeKeys = WidgetOptionUtil.getListByKey("attributeKeys", widgetOptions);
        this.validateAttributeKeys(attributeKeys);
        List attributeValues = Optional.ofNullable(attributes).map(Arrays::asList).orElseGet(Collections::emptyList);
        this.validateAttributeValues(attributeValues);
    }

    private void validateAttributeKeys(List<String> attributeKeys) {
        BusinessRule.expect(attributeKeys, CollectionUtils::isNotEmpty).verify(ErrorType.UNABLE_LOAD_WIDGET_CONTENT, new Object[]{"No keys were specified"});
        BusinessRule.expect(attributeKeys, cf -> cf.size() <= MAX_LEVEL_NUMBER).verify(ErrorType.UNABLE_LOAD_WIDGET_CONTENT, new Object[]{"Keys number is incorrect. Maximum keys count = " + MAX_LEVEL_NUMBER});
        attributeKeys.forEach(cf -> BusinessRule.expect((Object)cf, StringUtils::isNotBlank).verify(ErrorType.UNABLE_LOAD_WIDGET_CONTENT, new Object[]{"Current level key should be not blank"}));
    }

    private void validateWidgetOptions(WidgetOptions widgetOptions) {
        BusinessRule.expect((Object)widgetOptions, Objects::nonNull).verify(ErrorType.UNABLE_LOAD_WIDGET_CONTENT, new Object[]{"Widgets options not provided"});
        Integer passingRate = WidgetOptionUtil.getIntegerByKey("minPassingRate", widgetOptions).orElseThrow(() -> new ReportPortalException(ErrorType.UNABLE_LOAD_WIDGET_CONTENT, new Object[]{"Minimum passing rate option was not specified"}));
        BusinessRule.expect((Object)WidgetOptionUtil.isBooleanPresent("excludeSkipped", widgetOptions), isPresent -> isPresent).verify(ErrorType.UNABLE_LOAD_WIDGET_CONTENT, new Object[]{"Exclude skipped tests option was not specified"});
        BusinessRule.expect((Object)passingRate, v -> v >= 0 && v <= 100).verify(ErrorType.UNABLE_LOAD_WIDGET_CONTENT, new Object[]{"Minimum passing rate value should be greater or equal to 0 and less or equal to 100"});
    }

    private void validateAttributeValues(List<String> attributeValues) {
        attributeValues.forEach(value -> BusinessRule.expect((Object)value, Objects::nonNull).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Attribute value should be not null"}));
    }
}

