/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content.loader.materialized.generator;

import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.core.widget.content.loader.materialized.generator.ViewGenerator;
import com.epam.ta.reportportal.core.widget.util.WidgetOptionUtil;
import com.epam.ta.reportportal.dao.WidgetRepository;
import com.epam.ta.reportportal.entity.widget.Widget;
import com.epam.ta.reportportal.entity.widget.WidgetState;
import com.epam.ta.reportportal.ws.converter.builders.WidgetBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.util.MultiValueMap;

public class FailedViewStateGenerator
implements ViewGenerator {
    public static final Logger LOGGER = LoggerFactory.getLogger(FailedViewStateGenerator.class);
    private final ViewGenerator delegate;
    private final WidgetRepository widgetRepository;

    public FailedViewStateGenerator(ViewGenerator delegate, WidgetRepository widgetRepository) {
        this.delegate = delegate;
        this.widgetRepository = widgetRepository;
    }

    @Override
    public void generate(boolean refresh, String viewName, Widget widget, Filter launchesFilter, Sort launchesSort, MultiValueMap<String, String> params) {
        try {
            this.delegate.generate(refresh, viewName, widget, launchesFilter, launchesSort, params);
        }
        catch (Exception exc) {
            LOGGER.error("Error during view creation: " + exc.getMessage());
            this.widgetRepository.save((Object)new WidgetBuilder(widget).addOption("state", WidgetState.FAILED.getValue()).get());
            LOGGER.error("Generation failed. Widget {} - {}. State updated to: {}", new Object[]{widget.getWidgetType(), widget.getId(), WidgetOptionUtil.getValueByKey("state", widget.getWidgetOptions())});
        }
    }
}

