/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content.loader;

import com.epam.ta.reportportal.commons.querygen.Condition;
import com.epam.ta.reportportal.commons.querygen.ConvertibleCondition;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.FilterCondition;
import com.epam.ta.reportportal.core.widget.content.LoadContentStrategy;
import com.epam.ta.reportportal.core.widget.util.WidgetFilterUtil;
import com.epam.ta.reportportal.core.widget.util.WidgetOptionUtil;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.WidgetContentRepository;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.widget.WidgetOptions;
import com.epam.ta.reportportal.ws.converter.converters.LaunchConverter;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class TopTestCasesContentLoader
implements LoadContentStrategy {
    private final LaunchRepository launchRepository;
    private final LaunchConverter launchConverter;
    private final WidgetContentRepository widgetContentRepository;

    @Autowired
    public TopTestCasesContentLoader(LaunchRepository launchRepository, LaunchConverter launchConverter, WidgetContentRepository widgetContentRepository) {
        this.launchRepository = launchRepository;
        this.launchConverter = launchConverter;
        this.widgetContentRepository = widgetContentRepository;
    }

    @Override
    public Map<String, ?> loadContent(List<String> contentFields, Map<Filter, Sort> filterSortMapping, WidgetOptions widgetOptions, int limit) {
        String criteria = contentFields.get(0);
        Filter filter = WidgetFilterUtil.GROUP_FILTERS.apply(filterSortMapping.keySet()).withCondition((ConvertibleCondition)new FilterCondition(Condition.EQUALS, false, WidgetOptionUtil.getValueByKey("launchNameFilter", widgetOptions), "name"));
        return this.launchRepository.findLatestByFilter(filter).map(it -> Pair.of((Object)it, (Object)this.widgetContentRepository.topItemsByCriteria(filter, criteria, limit, Optional.ofNullable(widgetOptions.getOptions().get("includeMethods")).map(v -> BooleanUtils.toBoolean((String)String.valueOf(v))).orElse(false).booleanValue()))).filter(it -> !((List)it.getRight()).isEmpty()).map(it -> ImmutableMap.builder().put((Object)"latestLaunch", (Object)this.launchConverter.TO_RESOURCE.apply((Launch)it.getLeft())).put((Object)"result", it.getRight()).build()).orElse(Collections.emptyMap());
    }
}

