/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content.loader;

import com.epam.ta.reportportal.entity.widget.content.AbstractLaunchStatisticsContent;
import com.epam.ta.reportportal.entity.widget.content.ChartStatisticsContent;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;

public abstract class AbstractStatisticsContentLoader {
    protected Map<String, ChartStatisticsContent> groupByDate(List<ChartStatisticsContent> input, Period period) {
        LongSummaryStatistics statistics = input.stream().mapToLong(object -> object.getStartTime().toEpochMilli()).summaryStatistics();
        Instant start = Instant.ofEpochMilli(statistics.getMin());
        Instant end = Instant.ofEpochMilli(statistics.getMax());
        if (input.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, ChartStatisticsContent> chart = new LinkedHashMap<String, ChartStatisticsContent>();
        switch (period.ordinal()) {
            case 0: {
                this.proceedDailyChart(chart, start, end, input);
                this.groupStatistics("yyyy-MM-dd", input, chart);
                break;
            }
            case 1: {
                this.proceedDailyChart(chart, start, end, input);
                this.groupStatistics("yyyy-MM-dd", input, chart);
                break;
            }
            case 2: {
                this.proceedMonthlyChart(chart, start, end, input);
                this.groupStatistics("yyyy-MM", input, chart);
            }
        }
        return chart;
    }

    protected Map<String, ChartStatisticsContent> maxByDate(List<ChartStatisticsContent> statisticsContents, Period period, String contentField) {
        Function<ChartStatisticsContent, String> chartObjectToDate = chartObject -> AbstractStatisticsContentLoader.instantToFormattedString(chartObject.getStartTime(), "yyyy-MM-dd");
        BinaryOperator chartObjectReducer = (o1, o2) -> Integer.parseInt((String)o1.getValues().get(contentField)) > Integer.parseInt((String)o2.getValues().get(contentField)) ? o1 : o2;
        Map groupByDate = statisticsContents.stream().filter(content -> MapUtils.isNotEmpty((Map)content.getValues()) && Optional.ofNullable((String)content.getValues().get(contentField)).isPresent()).sorted(Comparator.comparing(AbstractLaunchStatisticsContent::getStartTime)).collect(Collectors.groupingBy(chartObjectToDate, LinkedHashMap::new, Collectors.reducing(chartObjectReducer)));
        Map<String, ChartStatisticsContent> range = this.groupByDate(statisticsContents, period);
        LinkedHashMap<String, ChartStatisticsContent> result = new LinkedHashMap<String, ChartStatisticsContent>();
        range.forEach((key, value) -> result.put((String)key, groupByDate.getOrDefault(key, Optional.of(this.createChartObject((ChartStatisticsContent)statisticsContents.get(0)))).get()));
        return result;
    }

    private void groupStatistics(String groupingPattern, List<ChartStatisticsContent> statisticsContents, Map<String, ChartStatisticsContent> chart) {
        Map groupedStatistics = statisticsContents.stream().collect(Collectors.groupingBy(c -> AbstractStatisticsContentLoader.instantToFormattedString(c.getStartTime(), groupingPattern), LinkedHashMap::new, Collectors.toList()));
        groupedStatistics.forEach((key, contents) -> chart.keySet().stream().filter(k -> k.startsWith((String)key)).findFirst().ifPresent(k -> {
            ChartStatisticsContent content = (ChartStatisticsContent)chart.get(k);
            contents.add(content);
            Map<String, String> values = contents.stream().map(v -> v.getValues().entrySet()).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, entry -> Optional.ofNullable((String)entry.getValue()).orElse("0"), (prev, curr) -> {
                prev = String.valueOf(Double.parseDouble(prev) + Double.parseDouble(curr));
                return prev;
            }));
            content.setValues(values);
            chart.put((String)k, content);
        }));
    }

    private void proceedDailyChart(Map<String, ChartStatisticsContent> chart, Instant intermediate, Instant end, List<ChartStatisticsContent> statisticsContents) {
        while (intermediate.isBefore(end)) {
            String interDate = AbstractStatisticsContentLoader.instantToFormattedString(intermediate, "yyyy-MM-dd");
            chart.put(interDate, this.createChartObject(statisticsContents.getFirst()));
            intermediate = intermediate.plus(1L, ChronoUnit.DAYS);
        }
        String endDate = AbstractStatisticsContentLoader.instantToFormattedString(end, "yyyy-MM-dd");
        chart.put(endDate, this.createChartObject(statisticsContents.getFirst()));
    }

    private static String instantToFormattedString(Instant date, String pattern) {
        return date.atOffset(ZoneOffset.UTC).toLocalDateTime().format(DateTimeFormatter.ofPattern(pattern));
    }

    private void proceedMonthlyChart(Map<String, ChartStatisticsContent> chart, Instant intermediate, Instant end, List<ChartStatisticsContent> statisticsContents) {
        while (intermediate.isBefore(end)) {
            if (intermediate.get(ChronoField.YEAR) == end.get(ChronoField.YEAR)) {
                if (intermediate.get(ChronoField.MONTH_OF_YEAR) != end.get(ChronoField.MONTH_OF_YEAR)) {
                    chart.put(AbstractStatisticsContentLoader.instantToFormattedString(intermediate, "yyyy-MM-dd"), this.createChartObject(statisticsContents.getFirst()));
                }
            } else {
                chart.put(AbstractStatisticsContentLoader.instantToFormattedString(intermediate, "yyyy-MM-dd"), this.createChartObject(statisticsContents.getFirst()));
            }
            intermediate = intermediate.plus(1L, ChronoUnit.MONTHS);
        }
        chart.put(AbstractStatisticsContentLoader.instantToFormattedString(end, "yyyy-MM-dd"), this.createChartObject(statisticsContents.getFirst()));
    }

    private ChartStatisticsContent createChartObject(ChartStatisticsContent input) {
        ChartStatisticsContent chartObject = new ChartStatisticsContent();
        chartObject.setValues(input.getValues().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> "0")));
        return chartObject;
    }

    public static enum Period {
        DAY(1),
        WEEK(7),
        MONTH(30);

        private int value;

        private Period(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static boolean isPresent(String name) {
            return Period.findByName(name).isPresent();
        }

        public static Optional<Period> findByName(String name) {
            return Arrays.stream(Period.values()).filter(time -> time.name().equalsIgnoreCase(name)).findAny();
        }
    }
}

