/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content.filter;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.ta.reportportal.commons.querygen.Condition;
import com.epam.ta.reportportal.commons.querygen.ConvertibleCondition;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.FilterCondition;
import com.epam.ta.reportportal.core.widget.content.filter.GeneralLaunchFilterStrategy;
import com.epam.ta.reportportal.core.widget.util.WidgetOptionUtil;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.widget.Widget;
import com.epam.ta.reportportal.entity.widget.WidgetOptions;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="launchHistoryFilterStrategy")
public class LaunchHistoryFilterStrategy
extends GeneralLaunchFilterStrategy {
    @Override
    protected Filter buildDefaultFilter(Widget widget, Long projectId) {
        this.validateWidgetOptions(widget.getWidgetOptions());
        String launchName = WidgetOptionUtil.getValueByKey("launchNameFilter", widget.getWidgetOptions());
        Filter filter = super.buildDefaultFilter(widget, projectId);
        return filter.withCondition((ConvertibleCondition)new FilterCondition(Condition.EQUALS, false, launchName, "name")).withCondition((ConvertibleCondition)new FilterCondition(Condition.IN, false, Stream.of(StatusEnum.FAILED, StatusEnum.PASSED, StatusEnum.STOPPED).map(Enum::name).collect(Collectors.joining(",")), "status"));
    }

    private void validateWidgetOptions(WidgetOptions widgetOptions) {
        BusinessRule.expect((Object)WidgetOptionUtil.getValueByKey("launchNameFilter", widgetOptions), StringUtils::isNotBlank).verify(ErrorType.UNABLE_LOAD_WIDGET_CONTENT, new Object[]{"launchNameFilter should be specified for widget."});
    }
}

