/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget;

import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.dao.WidgetRepository;
import com.epam.ta.reportportal.entity.dashboard.Dashboard;
import com.epam.ta.reportportal.entity.dashboard.DashboardWidget;
import com.epam.ta.reportportal.entity.widget.Widget;
import com.epam.ta.reportportal.model.widget.WidgetConfigResource;
import com.epam.ta.reportportal.ws.converter.converters.WidgetConverter;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class WidgetConfigurationService {
    private final WidgetRepository widgetRepository;

    public List<WidgetConfigResource> getWidgetsConfiguration(Dashboard dashboard, ReportPortalUser.ProjectDetails projectDetails) {
        return dashboard.getWidgets().stream().map(widget -> this.getWidgetConfig((DashboardWidget)widget, projectDetails)).collect(Collectors.toList());
    }

    private WidgetConfigResource getWidgetConfig(DashboardWidget dashboardWidget, ReportPortalUser.ProjectDetails projectDetails) {
        Long widgetId = dashboardWidget.getWidget().getId();
        Widget widget = (Widget)this.widgetRepository.findByIdAndProjectId(widgetId, projectDetails.getProjectId()).orElseThrow(() -> new ReportPortalException(ErrorType.WIDGET_NOT_FOUND_IN_PROJECT, new Object[]{widgetId, projectDetails.getProjectName()}));
        return WidgetConfigResource.builder().widgetObject(WidgetConverter.TO_OBJECT_MODEL.apply(dashboardWidget)).widgetResource(WidgetConverter.TO_WIDGET_RESOURCE.apply(widget)).build();
    }

    @Generated
    public WidgetConfigurationService(WidgetRepository widgetRepository) {
        this.widgetRepository = widgetRepository;
    }
}

