/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.user.impl;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.core.user.ApiKeyHandler;
import com.epam.ta.reportportal.dao.ApiKeyRepository;
import com.epam.ta.reportportal.entity.user.ApiKey;
import com.epam.ta.reportportal.model.ApiKeyRS;
import com.epam.ta.reportportal.model.ApiKeysRS;
import com.epam.ta.reportportal.ws.converter.converters.ApiKeyConverter;
import com.epam.ta.reportportal.ws.reporting.OperationCompletionRS;
import com.google.common.annotations.VisibleForTesting;
import jakarta.xml.bind.DatatypeConverter;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ApiKeyHandlerImpl
implements ApiKeyHandler {
    private static final String DELIMITER = "_";
    private static final String FORBIDDEN_SYMBOLS_PATTERN = "[ _]";
    private static final String REPLACE_PATTERN = "-";
    private static final int KEY_MIN_LENGTH = 1;
    private static final int KEY_MAX_LENGTH = 40;
    private final ApiKeyRepository apiKeyRepository;

    @Autowired
    public ApiKeyHandlerImpl(ApiKeyRepository apiKeyRepository) {
        this.apiKeyRepository = apiKeyRepository;
    }

    @Override
    public ApiKeyRS createApiKey(String name, Long userId) {
        name = name.trim();
        this.validateKeyName(name, userId);
        String apiToken = this.generateApiKey(name);
        String hashedApiToken = this.getHash(apiToken);
        ApiKey apiKey = new ApiKey();
        apiKey.setName(name);
        apiKey.setCreatedAt(Instant.now());
        apiKey.setUserId(userId);
        apiKey.setHash(hashedApiToken);
        this.apiKeyRepository.save((Object)apiKey);
        ApiKeyRS apiKeyRS = ApiKeyConverter.TO_RESOURCE.apply(apiKey);
        apiKeyRS.setApiKey(apiToken);
        return apiKeyRS;
    }

    @Override
    public OperationCompletionRS deleteApiKey(Long id, Long userId) {
        BusinessRule.expect((Object)this.apiKeyRepository.existsByIdAndUserId(id, userId), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.NOT_FOUND, new Object[]{"Api key"});
        this.apiKeyRepository.deleteById(id);
        return new OperationCompletionRS("Api key with ID = '" + id + "' was successfully deleted.");
    }

    @Override
    public ApiKeysRS getAllUsersApiKeys(Long userId) {
        List apiKeys = this.apiKeyRepository.findByUserId(userId);
        ApiKeysRS apiKeysRS = new ApiKeysRS();
        apiKeysRS.setApiKeys(apiKeys.stream().map(ApiKeyConverter.TO_RESOURCE).toList());
        return apiKeysRS;
    }

    private void validateKeyName(String keyName, Long userId) {
        BusinessRule.expect((Object)(1 <= keyName.length() && keyName.length() <= 40 ? 1 : 0), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"API Key name should have size from {} to {} characters.", (Object[])new Object[]{1, 40})});
        BusinessRule.expect((Object)this.apiKeyRepository.existsByNameAndUserId(keyName, userId), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"API Key with the same name already exists.", (Supplier[])new Supplier[0])});
    }

    @VisibleForTesting
    String generateApiKey(String keyName) {
        keyName = keyName.replaceAll(FORBIDDEN_SYMBOLS_PATTERN, REPLACE_PATTERN).replaceAll(",", "");
        byte[] keyBytes = keyName.getBytes(StandardCharsets.UTF_8);
        UUID uuid = UUID.randomUUID();
        byte[] uuidBytes = ApiKeyHandlerImpl.convertUUIDToBytes(uuid);
        byte[] keyUuidBytes = ArrayUtils.addAll((byte[])keyBytes, (byte[])uuidBytes);
        byte[] hash = DigestUtils.sha3_256((byte[])keyUuidBytes);
        byte[] uuidHashBytes = ArrayUtils.addAll((byte[])uuidBytes, (byte[])hash);
        return keyName + DELIMITER + Base64.getUrlEncoder().withoutPadding().encodeToString(uuidHashBytes);
    }

    private String getHash(String key) {
        return DatatypeConverter.printHexBinary((byte[])DigestUtils.sha3_256((String)key));
    }

    private static byte[] convertUUIDToBytes(UUID uuid) {
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return bb.array();
    }
}

