/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.project.settings.impl;

import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.core.project.settings.GetProjectSettingsHandler;
import com.epam.ta.reportportal.dao.ProjectRepository;
import com.epam.ta.reportportal.entity.project.Project;
import com.epam.ta.reportportal.model.project.config.ProjectSettingsResource;
import com.epam.ta.reportportal.ws.converter.converters.ProjectSettingsConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class GetProjectSettingsHandlerImpl
implements GetProjectSettingsHandler {
    private final ProjectRepository repository;

    @Autowired
    public GetProjectSettingsHandlerImpl(ProjectRepository repository) {
        this.repository = repository;
    }

    @Override
    public ProjectSettingsResource getProjectSettings(String projectName) {
        Project project = (Project)this.repository.findByName(projectName).orElseThrow(() -> new ReportPortalException(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName}));
        return ProjectSettingsConverter.TO_PROJECT_SETTINGS_RESOURCE.apply(project);
    }
}

