/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.preference.impl;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.preference.GetPreferenceHandler;
import com.epam.ta.reportportal.dao.UserPreferenceRepository;
import com.epam.ta.reportportal.model.filter.UserFilterResource;
import com.epam.ta.reportportal.model.preference.PreferenceResource;
import com.epam.ta.reportportal.ws.converter.converters.UserFilterConverter;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetPreferenceHandlerImpl
implements GetPreferenceHandler {
    private final UserPreferenceRepository userPreferenceRepository;

    @Autowired
    public GetPreferenceHandlerImpl(UserPreferenceRepository userPreferenceRepository) {
        this.userPreferenceRepository = userPreferenceRepository;
    }

    @Override
    public PreferenceResource getPreference(ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user) {
        List userPreferences = this.userPreferenceRepository.findByProjectIdAndUserId(projectDetails.getProjectId(), user.getUserId());
        PreferenceResource preferenceResource = new PreferenceResource();
        preferenceResource.setUserId(user.getUserId());
        preferenceResource.setProjectId(projectDetails.getProjectId());
        List<UserFilterResource> filters = userPreferences.stream().map(it -> UserFilterConverter.TO_FILTER_RESOURCE.apply(it.getFilter())).collect(Collectors.toList());
        preferenceResource.setFilters(filters);
        return preferenceResource;
    }
}

