/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.logging;

import ch.qos.logback.classic.Logger;
import com.epam.ta.reportportal.core.logging.HttpLogging;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Aspect
public class HttpLoggingAspect {
    private static final String READABLE_CONTENT_TYPES = "text/plain text/html text/xml application/json application/xml application/hal+xml application/hal+json";
    private static final String NEWLINE = "\n";
    private static final String BODY_DENOMINATOR = "-- Body --";
    private static final String BODY_BINARY_MARK = "<binary body>";
    private static final AtomicLong COUNTER = new AtomicLong();
    private static final List<String> SENSITIVE_HEADERS = List.of("Authorization");
    @Autowired
    private ObjectMapper objectMapper;

    @Around(value="execution(public * *(..)) && @annotation(annotation)")
    public Object log(ProceedingJoinPoint joinPoint, HttpLogging annotation) throws Throwable {
        Object response;
        Logger logger = (Logger)LoggerFactory.getLogger(joinPoint.getTarget().getClass());
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        Object requestBody = this.getBody(joinPoint, method);
        String prefix = method.getName();
        long requestCount = COUNTER.incrementAndGet();
        if (logger.isDebugEnabled()) {
            logger.debug(this.formatRequestRecord(requestCount, prefix, request, requestBody, annotation));
        }
        long start = System.currentTimeMillis();
        try {
            response = joinPoint.proceed();
            long executionTime = System.currentTimeMillis() - start;
            if (logger.isDebugEnabled()) {
                logger.debug(this.formatResponseRecord(requestCount, prefix, response, annotation, executionTime));
            }
        }
        catch (Throwable throwable) {
            logger.error(" (" + requestCount + ") - Error", throwable);
            throw throwable;
        }
        return response;
    }

    protected Object getBody(ProceedingJoinPoint joinPoint, Method method) {
        Object body = null;
        Object[] args = joinPoint.getArgs();
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Object arg = args[i];
            if (arg == null) continue;
            if (arg instanceof MultipartHttpServletRequest) {
                MultipartHttpServletRequest request = (MultipartHttpServletRequest)arg;
                body = BODY_BINARY_MARK;
                break;
            }
            if (parameters[i].isAnnotationPresent(RequestBody.class)) {
                body = arg;
                break;
            }
            if (!(arg instanceof HttpEntity)) continue;
            HttpEntity httpEntity = (HttpEntity)arg;
            body = httpEntity.getBody();
            break;
        }
        return body;
    }

    protected String formatRequestRecord(long count, String prefix, HttpServletRequest request, Object body, HttpLogging annotation) throws Exception {
        StringBuilder record = new StringBuilder();
        record.append(prefix).append(" (").append(count).append(')').append(" - Request").append(NEWLINE).append(' ').append(request.getMethod()).append(' ').append(URLDecoder.decode(request.getRequestURI(), StandardCharsets.UTF_8.displayName()));
        if (annotation.logHeaders()) {
            Enumeration names = request.getHeaderNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (this.containsSensitive(name)) continue;
                Enumeration values = request.getHeaders(name);
                record.append(NEWLINE).append(' ').append(name).append(':');
                boolean comma = false;
                while (values.hasMoreElements()) {
                    if (comma) {
                        record.append(',');
                    } else {
                        comma = true;
                    }
                    record.append(' ').append((String)values.nextElement());
                }
            }
        }
        if (body != null && annotation.logRequestBody()) {
            try {
                record.append(NEWLINE).append(' ').append(BODY_DENOMINATOR).append(NEWLINE).append(' ').append(this.objectMapper.writeValueAsString(body));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        return record.toString();
    }

    private boolean containsSensitive(String name) {
        return SENSITIVE_HEADERS.stream().anyMatch(sh -> sh.equalsIgnoreCase(name));
    }

    protected String formatResponseRecord(long count, String prefix, Object response, HttpLogging annotation, long executionTime) throws Exception {
        boolean binaryBody = false;
        StringBuilder record = new StringBuilder();
        record.append(prefix).append(" (").append(count).append(')').append(" - Response ");
        if (annotation.logExecutionTime()) {
            record.append(" (").append(executionTime).append(" ms)");
        }
        if (response instanceof ResponseEntity) {
            ResponseEntity responseEntity = (ResponseEntity)response;
            HttpStatus status = HttpStatus.resolve((int)responseEntity.getStatusCode().value());
            record.append(NEWLINE).append(' ').append(status).append(" - ").append(status.getReasonPhrase());
            if (annotation.logHeaders()) {
                HttpHeaders headers = responseEntity.getHeaders();
                for (String name : headers.keySet()) {
                    record.append(NEWLINE).append(' ').append(name).append(':');
                    boolean comma = false;
                    for (String value : headers.get((Object)name)) {
                        if ("Content-Type".equals(name) && !this.readableContent(value)) {
                            binaryBody = true;
                        }
                        if (comma) {
                            record.append(',');
                        } else {
                            comma = true;
                        }
                        record.append(' ').append(value);
                    }
                }
            }
            if (annotation.logResponseBody()) {
                record.append(NEWLINE).append(' ').append(BODY_DENOMINATOR);
                if (binaryBody) {
                    record.append(NEWLINE).append(' ').append('\"').append(BODY_BINARY_MARK).append('\"');
                } else {
                    try {
                        record.append(NEWLINE).append(' ').append(this.objectMapper.writeValueAsString(((ResponseEntity)response).getBody()));
                    }
                    catch (JsonProcessingException ex) {
                        record.append(NEWLINE).append(' ').append((String)((ResponseEntity)response).getBody());
                    }
                }
            }
        } else if (annotation.logResponseBody()) {
            record.append(NEWLINE).append(' ').append("Status").append(" - ").append("OK (method return)");
            record.append(NEWLINE).append(' ').append(BODY_DENOMINATOR);
            try {
                record.append(NEWLINE).append(' ').append(this.objectMapper.writeValueAsString(response));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        return record.toString();
    }

    protected boolean readableContent(String value) {
        int idx = value.indexOf(59);
        return READABLE_CONTENT_TYPES.contains(value.substring(0, idx > 0 ? idx : value.length()));
    }
}

