/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.log.impl;

import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.binary.AttachmentBinaryDataService;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.item.TestItemService;
import com.epam.ta.reportportal.core.log.CreateLogHandler;
import com.epam.ta.reportportal.core.log.LogService;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.LogRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.attachment.AttachmentMetaInfo;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.log.Log;
import com.epam.ta.reportportal.entity.log.LogFull;
import com.epam.ta.reportportal.ws.converter.builders.LogFullBuilder;
import com.epam.ta.reportportal.ws.converter.converters.LogConverter;
import com.epam.ta.reportportal.ws.reporting.EntryCreatedAsyncRS;
import com.epam.ta.reportportal.ws.reporting.SaveLogRQ;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Primary;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Primary
@Transactional
public class CreateLogHandlerImpl
implements CreateLogHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateLogHandlerImpl.class);
    @Autowired
    TestItemRepository testItemRepository;
    @Autowired
    TestItemService testItemService;
    @Autowired
    LaunchRepository launchRepository;
    @Autowired
    LogRepository logRepository;
    @Autowired
    AttachmentBinaryDataService attachmentBinaryDataService;
    @Autowired
    private LogService logService;
    @Autowired
    @Qualifier(value="saveLogsTaskExecutor")
    private TaskExecutor taskExecutor;

    @Override
    @Nonnull
    public EntryCreatedAsyncRS createLog(@Nonnull SaveLogRQ request, MultipartFile file, ReportPortalUser.ProjectDetails projectDetails) {
        this.validate(request);
        LogFullBuilder logFullBuilder = new LogFullBuilder().addSaveLogRq(request).addProjectId(projectDetails.getProjectId());
        Launch launch = this.testItemRepository.findByUuid(request.getItemUuid()).map(item -> {
            logFullBuilder.addTestItem((TestItem)item);
            return this.testItemService.getEffectiveLaunch((TestItem)item);
        }).orElseGet(() -> this.launchRepository.findByUuid(request.getLaunchUuid()).map(l -> {
            logFullBuilder.addLaunch((Launch)l);
            return l;
        }).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{request.getLaunchUuid()})));
        LogFull logFull = logFullBuilder.get();
        Log log = LogConverter.LOG_FULL_TO_LOG.apply(logFull);
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> (Log)this.logRepository.saveAndFlush((Object)log), (Executor)this.taskExecutor).thenAcceptAsync(savedLog -> {
            logFull.setId(savedLog.getId());
            this.logService.saveLogMessage(logFull, launch.getId());
            if (file != null) {
                this.saveBinaryData(file, launch, (Log)savedLog);
            }
        }, (Executor)this.taskExecutor)).exceptionally(e -> {
            LOGGER.error("Failed to save log with attachments", e);
            return null;
        });
        return new EntryCreatedAsyncRS(log.getUuid());
    }

    private void saveBinaryData(MultipartFile file, Launch launch, Log savedLog) {
        AttachmentMetaInfo.AttachmentMetaInfoBuilder metaInfoBuilder = AttachmentMetaInfo.builder().withProjectId(launch.getProjectId()).withLaunchId(launch.getId()).withLaunchUuid(launch.getUuid()).withLogId(savedLog.getId()).withFileName(file.getOriginalFilename()).withLogUuid(savedLog.getUuid()).withCreationDate(Instant.now());
        Optional.ofNullable(savedLog.getTestItem()).map(TestItem::getItemId).ifPresent(arg_0 -> ((AttachmentMetaInfo.AttachmentMetaInfoBuilder)metaInfoBuilder).withItemId(arg_0));
        this.attachmentBinaryDataService.saveFileAndAttachToLog(file, metaInfoBuilder.build());
    }
}

