/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.log;

import com.epam.reportportal.model.analyzer.IndexLog;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.log.LogService;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.LogRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.dao.custom.ElasticSearchClient;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.entity.log.Log;
import com.epam.ta.reportportal.entity.log.LogFull;
import com.epam.ta.reportportal.entity.log.LogMessage;
import com.epam.ta.reportportal.ws.converter.converters.LogConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.logging.log4j.util.Strings;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Primary;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Primary
@Service
@ConditionalOnProperty(prefix="rp.searchengine", name={"host"})
public class ElasticLogService
implements LogService {
    private final AmqpTemplate amqpTemplate;
    private final ElasticSearchClient elasticSearchClient;
    private final LogRepository logRepository;
    private final LaunchRepository launchRepository;
    private final TestItemRepository testItemRepository;

    public ElasticLogService(@Qualifier(value="rabbitTemplate") AmqpTemplate amqpTemplate, ElasticSearchClient elasticSearchClient, LogRepository logRepository, LaunchRepository launchRepository, TestItemRepository testItemRepository) {
        this.amqpTemplate = amqpTemplate;
        this.elasticSearchClient = elasticSearchClient;
        this.logRepository = logRepository;
        this.launchRepository = launchRepository;
        this.testItemRepository = testItemRepository;
    }

    @Override
    public void saveLogMessage(LogFull logFull, Long launchId) {
        if (Objects.isNull(logFull)) {
            return;
        }
        this.amqpTemplate.convertAndSend("processing", "log_message_saving", (Object)this.convertLogToLogMessage(logFull, launchId));
    }

    @Override
    public void saveLogMessageList(List<LogFull> logFullList, Long launchId) {
        if (CollectionUtils.isEmpty(logFullList)) {
            return;
        }
        logFullList.stream().filter(Objects::nonNull).forEach(logFull -> this.saveLogMessage((LogFull)logFull, launchId));
    }

    @Override
    public void deleteLogMessage(Long projectId, Long logId) {
        this.elasticSearchClient.deleteLogsByLogIdAndProjectId(projectId, logId);
    }

    @Override
    public void deleteLogMessageByTestItemSet(Long projectId, Set<Long> itemIds) {
        this.elasticSearchClient.deleteLogsByItemSetAndProjectId(projectId, itemIds);
    }

    @Override
    public void deleteLogMessageByLaunch(Long projectId, Long launchId) {
        this.elasticSearchClient.deleteLogsByLaunchIdAndProjectId(projectId, launchId);
    }

    @Override
    public void deleteLogMessageByLaunchList(Long projectId, List<Long> launchIds) {
        this.elasticSearchClient.deleteLogsByLaunchListAndProjectId(projectId, launchIds);
    }

    @Override
    public void deleteLogMessageByProject(Long projectId) {
        this.elasticSearchClient.deleteLogsByProjectId(projectId);
    }

    @Override
    public Map<Long, List<IndexLog>> findAllIndexUnderTestItemByLaunchIdAndTestItemIdsAndLogLevelGte(Long launchId, List<Long> itemIds, int logLevel) {
        Long projectId = this.launchRepository.findById((Object)launchId).map(Launch::getProjectId).orElseThrow();
        Map indexLogMap = this.logRepository.findAllIndexUnderTestItemByLaunchIdAndTestItemIdsAndLogLevelGte(launchId, itemIds, logLevel);
        return this.wrapLogsWithLogMessages(projectId, indexLogMap);
    }

    private Map<Long, List<IndexLog>> wrapLogsWithLogMessages(Long projectId, Map<Long, List<IndexLog>> indexLogMap) {
        Map<Long, List<Object>> wrappedMap = new HashMap<Long, List<IndexLog>>();
        if (indexLogMap != null && indexLogMap.size() > 0) {
            List logIds = indexLogMap.values().stream().flatMap(Collection::stream).map(IndexLog::getLogId).collect(Collectors.toList());
            Map logMessageMap = this.elasticSearchClient.getLogMessagesByProjectIdAndIds(projectId, logIds);
            wrappedMap = indexLogMap.entrySet().stream().peek(indexLogEntry -> {
                List indexLogList = ((List)indexLogEntry.getValue()).stream().peek(indexLog -> {
                    LogMessage logMessage = (LogMessage)logMessageMap.get(indexLog.getLogId());
                    if (logMessage != null) {
                        indexLog.setMessage(logMessage.getLogMessage());
                    }
                }).collect(Collectors.toList());
                indexLogEntry.setValue(indexLogList);
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        return wrappedMap;
    }

    @Override
    public List<String> findMessagesByLaunchIdAndItemIdAndPathAndLevelGte(Long launchId, Long itemId, String path, Integer level) {
        Long projectId = this.launchRepository.findById((Object)launchId).map(Launch::getProjectId).orElseThrow();
        List logIds = this.logRepository.findIdsByLaunchIdAndItemIdAndPathAndLevelGte(launchId, itemId, path, level);
        return this.elasticSearchClient.getLogMessagesByProjectIdAndIds(projectId, logIds).values().stream().map(LogMessage::getLogMessage).collect(Collectors.toList());
    }

    @Override
    public List<LogFull> findAllUnderTestItemByLaunchIdAndTestItemIdsAndLogLevelGte(Long launchId, List<Long> itemIds, int logLevel) {
        return this.wrapLogsWithLogMessages(this.logRepository.findAllUnderTestItemByLaunchIdAndTestItemIdsAndLogLevelGte(launchId, itemIds, logLevel));
    }

    @Override
    public List<LogFull> findLatestUnderTestItemByLaunchIdAndTestItemIdsAndLogLevelGte(Long launchId, Long itemId, int logLevel, int limit) {
        return this.wrapLogsWithLogMessages(this.logRepository.findLatestUnderTestItemByLaunchIdAndTestItemIdsAndLogLevelGte(launchId, itemId, logLevel, limit));
    }

    @Override
    public List<Log> findAllUnderTestItemByLaunchIdAndTestItemIdsWithLimit(Long launchId, List<Long> itemIds, int limit) {
        return this.logRepository.findAllUnderTestItemByLaunchIdAndTestItemIdsWithLimit(launchId, itemIds, limit);
    }

    @Override
    public List<Log> findByTestItemId(Long itemId, int limit) {
        return this.logRepository.findByTestItemId(itemId, limit);
    }

    @Override
    public List<Log> findByTestItemId(Long itemId) {
        return this.logRepository.findByTestItemId(itemId);
    }

    @Override
    public List<LogFull> findByFilter(Queryable filter) {
        return this.wrapLogsWithLogMessages(this.logRepository.findByFilter(filter));
    }

    @Override
    public Page<LogFull> findByFilter(Queryable filter, Pageable pageable) {
        Page byFilter = this.logRepository.findByFilter(filter, pageable);
        return byFilter.map(this::getLogFull);
    }

    @Override
    public List<LogFull> findAllById(Iterable<Long> ids) {
        return this.wrapLogsWithLogMessages(this.logRepository.findAllById(ids));
    }

    @Override
    public Optional<LogFull> findById(Long id) {
        return this.logRepository.findById((Object)id).map(this::getLogFull);
    }

    @Override
    public Optional<LogFull> findByUuid(String uuid) {
        return this.logRepository.findByUuid(uuid).map(this::getLogFull);
    }

    @Override
    public List<Long> selectTestItemIdsByStringLogMessage(Collection<Long> itemIds, Integer logLevel, String pattern) {
        return this.testItemRepository.selectIdsByStringLogMessage(itemIds, logLevel, pattern);
    }

    @Override
    public List<Long> selectTestItemIdsUnderByStringLogMessage(Long launchId, Collection<Long> itemIds, Integer logLevel, String pattern) {
        return this.testItemRepository.selectIdsUnderByStringLogMessage(launchId, itemIds, logLevel, pattern);
    }

    @Override
    public List<Long> selectTestItemIdsByRegexLogMessage(Collection<Long> itemIds, Integer logLevel, String pattern) {
        return this.testItemRepository.selectIdsByRegexLogMessage(itemIds, logLevel, pattern);
    }

    @Override
    public List<Long> selectTestItemIdsUnderByRegexLogMessage(Long launchId, Collection<Long> itemIds, Integer logLevel, String pattern) {
        return this.testItemRepository.selectIdsUnderByRegexLogMessage(launchId, itemIds, logLevel, pattern);
    }

    private Long getProjectId(Collection<Long> itemIds) {
        Long id = itemIds.stream().findFirst().get();
        return this.testItemRepository.findById((Object)id).map(testItem -> this.launchRepository.findById((Object)testItem.getLaunchId()).map(Launch::getProjectId).orElseThrow()).orElseThrow();
    }

    private LogMessage convertLogToLogMessage(LogFull logFull, Long launchId) {
        Long itemId = Objects.nonNull(logFull.getTestItem()) ? logFull.getTestItem().getItemId() : null;
        return new LogMessage(logFull.getId(), logFull.getLogTime(), logFull.getLogMessage(), itemId, launchId, logFull.getProjectId());
    }

    private List<LogFull> wrapLogsWithLogMessages(List<Log> logList) {
        ArrayList<Object> logFullList = new ArrayList<LogFull>();
        if (CollectionUtils.isNotEmpty(logList)) {
            logFullList = new ArrayList(logList.size());
            HashMap logMessageMap = new HashMap();
            Map logIdsGroupByProject = logList.stream().collect(Collectors.groupingBy(Log::getProjectId, Collectors.mapping(Log::getId, Collectors.toList())));
            for (Map.Entry logIdsPerProject : logIdsGroupByProject.entrySet()) {
                Long projectId = logIdsPerProject.getKey();
                List logIds = logIdsPerProject.getValue();
                logMessageMap.putAll(this.elasticSearchClient.getLogMessagesByProjectIdAndIds(projectId, logIds));
            }
            for (Log log : logList) {
                String logMessage = logMessageMap.get(log.getId()) != null ? ((LogMessage)logMessageMap.get(log.getId())).getLogMessage() : log.getLogMessage();
                LogFull logFull = this.getLogFull(log, logMessage);
                logFullList.add(logFull);
            }
        }
        return logFullList;
    }

    private LogFull getLogFull(Log log) {
        LogMessage logMessage = this.elasticSearchClient.getLogMessageByProjectIdAndId(log.getProjectId(), log.getId());
        String message = logMessage != null ? logMessage.getLogMessage() : null;
        return this.getLogFull(log, message);
    }

    private LogFull getLogFull(Log log, String logMessage) {
        LogFull logFull = LogConverter.LOG_TO_LOG_FULL.apply(log);
        if (Strings.isNotBlank((String)logMessage)) {
            logFull.setLogMessage(logMessage);
        }
        return logFull;
    }

    private List<Long> selectTestItemIdsUnderByLogMessage(Long launchId, Collection<Long> itemIds, Integer logLevel, String string, boolean selectByPattern) {
        Long projectId = this.getProjectId(itemIds);
        ArrayList<Long> matchedItemIds = new ArrayList<Long>();
        for (Long itemId : itemIds) {
            List logIdsPg = this.testItemRepository.selectLogIdsUnderWithLogLevelCondition(launchId, itemIds, logLevel);
            List nestedItemsMatchedIds = selectByPattern ? this.elasticSearchClient.searchTestItemIdsByLogIdsAndRegexp(projectId, (Collection)logIdsPg, string) : this.elasticSearchClient.searchTestItemIdsByLogIdsAndString(projectId, (Collection)logIdsPg, string);
            if (!CollectionUtils.isNotEmpty((Collection)nestedItemsMatchedIds)) continue;
            matchedItemIds.add(itemId);
        }
        return matchedItemIds;
    }
}

