/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.launch.rerun;

import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.commons.querygen.Condition;
import com.epam.ta.reportportal.commons.querygen.ConvertibleCondition;
import com.epam.ta.reportportal.commons.querygen.Filter;
import com.epam.ta.reportportal.commons.querygen.FilterCondition;
import com.epam.ta.reportportal.commons.querygen.Queryable;
import com.epam.ta.reportportal.core.events.activity.item.ItemRetryEvent;
import com.epam.ta.reportportal.core.item.identity.IdentityUtil;
import com.epam.ta.reportportal.core.item.identity.TestCaseHashGenerator;
import com.epam.ta.reportportal.core.item.identity.UniqueIdGenerator;
import com.epam.ta.reportportal.core.item.impl.rerun.RerunSearcher;
import com.epam.ta.reportportal.core.item.impl.retry.RetryHandler;
import com.epam.ta.reportportal.core.item.validator.parent.ParentItemValidator;
import com.epam.ta.reportportal.core.launch.rerun.RerunHandler;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.dao.TestItemRepository;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.ws.converter.builders.LaunchBuilder;
import com.epam.ta.reportportal.ws.converter.builders.TestCaseIdEntry;
import com.epam.ta.reportportal.ws.converter.builders.TestItemBuilder;
import com.epam.ta.reportportal.ws.reporting.ItemCreatedRS;
import com.epam.ta.reportportal.ws.reporting.StartLaunchRQ;
import com.epam.ta.reportportal.ws.reporting.StartTestItemRQ;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class RerunHandlerImpl
implements RerunHandler {
    private final TestItemRepository testItemRepository;
    private final LaunchRepository launchRepository;
    private final UniqueIdGenerator uniqueIdGenerator;
    private final TestCaseHashGenerator testCaseHashGenerator;
    private final ApplicationEventPublisher eventPublisher;
    private final RerunSearcher rerunSearcher;
    private final List<ParentItemValidator> parentItemValidators;
    private final RetryHandler retryHandler;

    @Autowired
    public RerunHandlerImpl(TestItemRepository testItemRepository, LaunchRepository launchRepository, UniqueIdGenerator uniqueIdGenerator, TestCaseHashGenerator testCaseHashGenerator, ApplicationEventPublisher eventPublisher, RerunSearcher rerunSearcher, List<ParentItemValidator> parentItemValidators, RetryHandler retryHandler) {
        this.testItemRepository = testItemRepository;
        this.launchRepository = launchRepository;
        this.uniqueIdGenerator = uniqueIdGenerator;
        this.testCaseHashGenerator = testCaseHashGenerator;
        this.eventPublisher = eventPublisher;
        this.rerunSearcher = rerunSearcher;
        this.parentItemValidators = parentItemValidators;
        this.retryHandler = retryHandler;
    }

    @Override
    public Launch handleLaunch(StartLaunchRQ request, Long projectId, ReportPortalUser user) {
        Optional launchOptional = !StringUtils.hasText((String)request.getRerunOf()) ? this.launchRepository.findLatestByNameAndProjectId(request.getName(), projectId) : this.launchRepository.findByUuid(request.getRerunOf());
        Launch existingLaunch = (Launch)launchOptional.orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{Optional.ofNullable(request.getRerunOf()).orElse(request.getName())}));
        LaunchBuilder launchBuilder = new LaunchBuilder(existingLaunch).addDescription(request.getDescription()).addMode(request.getMode()).addAttributes(request.getAttributes());
        Launch launch = launchBuilder.get();
        launch.setStatus(StatusEnum.IN_PROGRESS);
        launch.setRerun(true);
        Optional.ofNullable(request.getUuid()).ifPresent(arg_0 -> ((Launch)launch).setUuid(arg_0));
        return launch;
    }

    @Override
    public String getRerunLaunchUuid(String rerunOf, String launchName, Long projectId) {
        if (StringUtils.hasText((String)rerunOf)) {
            return rerunOf;
        }
        Launch rerunLaunch = (Launch)this.launchRepository.findLatestByNameAndProjectId(launchName, projectId).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{Optional.ofNullable(rerunOf).orElse(rerunOf)}));
        return rerunLaunch.getUuid();
    }

    @Override
    public Optional<ItemCreatedRS> handleRootItem(StartTestItemRQ request, Launch launch) {
        Integer testCaseHash = this.getTestCaseHash(request, launch);
        Filter parentItemFilter = this.getRootItemFilter(launch, testCaseHash, request.getName());
        return this.rerunSearcher.findItem((Queryable)parentItemFilter).flatMap(arg_0 -> ((TestItemRepository)this.testItemRepository).findById(arg_0)).map(it -> this.updateRootItem(request, (TestItem)it));
    }

    private Integer getTestCaseHash(StartTestItemRQ request, Launch launch) {
        TestCaseIdEntry testCaseIdEntry = TestItemBuilder.processTestCaseId(request);
        return Optional.ofNullable(testCaseIdEntry.getId()).map(id -> testCaseIdEntry.getHash()).orElseGet(() -> {
            TestItem newItem = new TestItemBuilder().addStartItemRequest(request).get();
            return this.testCaseHashGenerator.generate(newItem, Collections.emptyList(), launch.getProjectId());
        });
    }

    @Override
    public Optional<ItemCreatedRS> handleChildItem(StartTestItemRQ request, Launch launch, String parentUuid) {
        if (!request.isHasStats()) {
            return Optional.empty();
        }
        Pair pathName = (Pair)this.testItemRepository.selectPath(parentUuid).orElseThrow(() -> new ReportPortalException(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{parentUuid}));
        TestItem newItem = new TestItemBuilder().addLaunchId(launch.getId()).addStartItemRequest(request).addAttributes(request.getAttributes()).addParentId((Long)pathName.getFirst()).get();
        if (Objects.isNull(newItem.getTestCaseId())) {
            newItem.setTestCaseHash(this.testCaseHashGenerator.generate(newItem, IdentityUtil.getItemTreeIds((String)pathName.getSecond()), launch.getProjectId()));
        }
        Filter childItemFilter = this.getChildItemFilter(launch, newItem.getTestCaseHash(), (Long)pathName.getFirst());
        return this.rerunSearcher.findItem((Queryable)childItemFilter).flatMap(arg_0 -> ((TestItemRepository)this.testItemRepository).findById(arg_0)).flatMap(foundItem -> {
            if (!foundItem.isHasChildren()) {
                TestItem parent = this.testItemRepository.findIdByUuidForUpdate(parentUuid).map(arg_0 -> ((TestItemRepository)this.testItemRepository).getOne(arg_0)).orElseThrow(() -> new ReportPortalException(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{parentUuid}));
                this.parentItemValidators.forEach(v -> v.validate(request, parent));
                return Optional.of(this.handleRetry(launch, newItem, (TestItem)foundItem, parent));
            }
            if (foundItem.getName().equals(newItem.getName())) {
                return Optional.of(this.updateRootItem(request, (TestItem)foundItem));
            }
            childItemFilter.withCondition((ConvertibleCondition)new FilterCondition(Condition.EQUALS, false, newItem.getName(), "name"));
            return this.rerunSearcher.findItem((Queryable)childItemFilter).flatMap(arg_0 -> ((TestItemRepository)this.testItemRepository).findById(arg_0)).map(it -> this.updateRootItem(request, (TestItem)it));
        });
    }

    private Filter getCommonFilter(Long launchId, Integer testCaseHash) {
        return Filter.builder().withTarget(TestItem.class).withCondition((ConvertibleCondition)new FilterCondition(Condition.EQUALS, false, String.valueOf(launchId), "launchId")).withCondition((ConvertibleCondition)new FilterCondition(Condition.EQUALS, false, String.valueOf(testCaseHash), "testCaseHash")).build();
    }

    private Filter getRootItemFilter(Launch launch, Integer testCaseHash, String name) {
        return this.getCommonFilter(launch.getId(), testCaseHash).withCondition((ConvertibleCondition)new FilterCondition(Condition.EQUALS, false, name, "name")).withCondition((ConvertibleCondition)new FilterCondition(Condition.EXISTS, true, "1", "parentId"));
    }

    private Filter getChildItemFilter(Launch launch, Integer testCaseHash, Long parentId) {
        return this.getCommonFilter(launch.getId(), testCaseHash).withCondition((ConvertibleCondition)new FilterCondition(Condition.EQUALS, false, String.valueOf(parentId), "parentId"));
    }

    private ItemCreatedRS handleRetry(Launch launch, TestItem newItem, TestItem foundItem, TestItem parentItem) {
        this.eventPublisher.publishEvent((Object)ItemRetryEvent.of(launch.getProjectId(), launch.getId(), foundItem.getItemId()));
        this.testItemRepository.save((Object)newItem);
        newItem.setPath(parentItem.getPath() + "." + newItem.getItemId());
        this.generateUniqueId(launch, newItem);
        this.retryHandler.handleRetries(launch, newItem, foundItem.getItemId());
        return new ItemCreatedRS(newItem.getUuid(), newItem.getUniqueId());
    }

    private void generateUniqueId(Launch launch, TestItem item) {
        if (null == item.getUniqueId()) {
            item.setUniqueId(this.uniqueIdGenerator.generate(item, IdentityUtil.getParentIds(item), launch));
        }
    }

    private ItemCreatedRS updateRootItem(StartTestItemRQ request, TestItem foundItem) {
        foundItem = new TestItemBuilder(foundItem).addDescription(request.getDescription()).overwriteAttributes(request.getAttributes()).addStatus(StatusEnum.IN_PROGRESS).get();
        Optional.ofNullable(request.getUuid()).ifPresent(arg_0 -> ((TestItem)foundItem).setUuid(arg_0));
        return new ItemCreatedRS(foundItem.getUuid(), foundItem.getUniqueId());
    }
}

