/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.launch.impl;

import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.reportportal.rules.exception.ReportPortalException;
import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.events.activity.LaunchFinishedEvent;
import com.epam.ta.reportportal.core.hierarchy.FinishHierarchyHandler;
import com.epam.ta.reportportal.core.launch.FinishLaunchHandler;
import com.epam.ta.reportportal.core.launch.util.LaunchValidator;
import com.epam.ta.reportportal.core.launch.util.LinkGenerator;
import com.epam.ta.reportportal.dao.LaunchRepository;
import com.epam.ta.reportportal.entity.enums.StatusEnum;
import com.epam.ta.reportportal.entity.launch.Launch;
import com.epam.ta.reportportal.model.launch.FinishLaunchRS;
import com.epam.ta.reportportal.ws.converter.builders.LaunchBuilder;
import com.epam.ta.reportportal.ws.reporting.FinishExecutionRQ;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Primary
@Transactional
public class FinishLaunchHandlerImpl
implements FinishLaunchHandler {
    private final LaunchRepository launchRepository;
    private final FinishHierarchyHandler<Launch> finishHierarchyHandler;
    private final ApplicationEventPublisher eventPublisher;

    @Autowired
    public FinishLaunchHandlerImpl(LaunchRepository launchRepository, @Qualifier(value="finishLaunchHierarchyHandler") FinishHierarchyHandler<Launch> finishHierarchyHandler, ApplicationEventPublisher eventPublisher) {
        this.launchRepository = launchRepository;
        this.finishHierarchyHandler = finishHierarchyHandler;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public FinishLaunchRS finishLaunch(String launchId, FinishExecutionRQ finishLaunchRQ, ReportPortalUser.ProjectDetails projectDetails, ReportPortalUser user, String baseUrl) {
        Launch launch = (Launch)this.launchRepository.findByUuid(launchId).orElseThrow(() -> new ReportPortalException(ErrorType.LAUNCH_NOT_FOUND, new Object[]{launchId}));
        LaunchValidator.validateRoles(launch, user, projectDetails);
        LaunchValidator.validate(launch, finishLaunchRQ);
        Optional status = StatusEnum.fromValue((String)finishLaunchRQ.getStatus());
        Long id = launch.getId();
        int finishedCount = this.finishHierarchyHandler.finishDescendants(launch, status.orElse(StatusEnum.INTERRUPTED), finishLaunchRQ.getEndTime(), user, projectDetails);
        if (finishedCount > 0) {
            launch.setStatus(this.launchRepository.hasRootItemsWithStatusNotEqual(id, new String[]{StatusEnum.PASSED.name(), StatusEnum.INFO.name(), StatusEnum.WARN.name()}) ? StatusEnum.FAILED : StatusEnum.PASSED);
        } else {
            launch.setStatus(status.orElseGet(() -> this.launchRepository.hasRootItemsWithStatusNotEqual(id, new String[]{StatusEnum.PASSED.name(), StatusEnum.INFO.name(), StatusEnum.WARN.name()}) ? StatusEnum.FAILED : StatusEnum.PASSED));
        }
        launch = new LaunchBuilder(launch).addDescription(this.buildDescription(launch.getDescription(), finishLaunchRQ.getDescription())).addAttributes(finishLaunchRQ.getAttributes()).addEndTime(finishLaunchRQ.getEndTime()).get();
        String launchLink = LinkGenerator.generateLaunchLink(baseUrl, projectDetails.getProjectName(), String.valueOf(launch.getId()));
        this.eventPublisher.publishEvent((Object)new LaunchFinishedEvent(launch, user, baseUrl));
        FinishLaunchRS response = new FinishLaunchRS();
        response.setId(launch.getUuid());
        response.setNumber(launch.getNumber());
        response.setLink(launchLink);
        return response;
    }

    private String buildDescription(String existDescription, String fromRequestDescription) {
        if (null != existDescription) {
            return null != fromRequestDescription ? existDescription + " " + fromRequestDescription : existDescription;
        }
        return fromRequestDescription;
    }
}

