/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.launch.cluster;

import com.epam.ta.reportportal.core.analyzer.auto.impl.AnalyzerStatusCache;
import com.epam.ta.reportportal.core.launch.cluster.UniqueErrorGenerator;
import com.epam.ta.reportportal.core.launch.cluster.config.GenerateClustersConfig;
import com.epam.ta.reportportal.pipeline.PipelineConstructor;
import com.epam.ta.reportportal.pipeline.TransactionalPipeline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class UniqueErrorGeneratorAsync
extends UniqueErrorGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(UniqueErrorGeneratorAsync.class);
    private final TaskExecutor logClusterExecutor;

    @Autowired
    public UniqueErrorGeneratorAsync(AnalyzerStatusCache analyzerStatusCache, PipelineConstructor<GenerateClustersConfig> generateClustersPipelineConstructor, TransactionalPipeline transactionalPipeline, @Qualifier(value="logClusterExecutor") TaskExecutor logClusterExecutor) {
        super(analyzerStatusCache, generateClustersPipelineConstructor, transactionalPipeline);
        this.logClusterExecutor = logClusterExecutor;
    }

    @Override
    protected void generateClusters(GenerateClustersConfig config) {
        try {
            this.logClusterExecutor.execute(() -> super.generateClusters(config));
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            this.cleanCache(config.getEntityContext());
        }
    }
}

