/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.launch.cluster;

import com.epam.reportportal.model.project.AnalyzerConfig;
import com.epam.ta.reportportal.core.analyzer.auto.impl.AnalyzerUtils;
import com.epam.ta.reportportal.core.launch.cluster.ClusterGenerator;
import com.epam.ta.reportportal.core.launch.cluster.config.ClusterEntityContext;
import com.epam.ta.reportportal.core.launch.cluster.config.GenerateClustersConfig;
import com.epam.ta.reportportal.model.project.UniqueErrorConfig;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;

public class UniqueErrorAnalysisStarter {
    private final ClusterGenerator clusterGenerator;

    public UniqueErrorAnalysisStarter(ClusterGenerator clusterGenerator) {
        this.clusterGenerator = clusterGenerator;
    }

    public void start(ClusterEntityContext entityContext, Map<String, String> projectConfig) {
        GenerateClustersConfig clustersConfig = new GenerateClustersConfig();
        clustersConfig.setEntityContext(entityContext);
        clustersConfig.setForUpdate(CollectionUtils.isNotEmpty(entityContext.getItemIds()));
        UniqueErrorConfig uniqueErrorConfig = AnalyzerUtils.getUniqueErrorConfig(projectConfig);
        clustersConfig.setCleanNumbers(uniqueErrorConfig.isRemoveNumbers());
        AnalyzerConfig analyzerConfig = AnalyzerUtils.getAnalyzerConfig(projectConfig);
        clustersConfig.setAnalyzerConfig(analyzerConfig);
        this.clusterGenerator.generate(clustersConfig);
    }
}

