/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.launch.cluster;

import com.epam.ta.reportportal.core.analyzer.auto.client.model.cluster.ClusterData;
import com.epam.ta.reportportal.core.analyzer.auto.client.model.cluster.ClusterInfoRs;
import com.epam.ta.reportportal.core.launch.cluster.CreateClusterHandler;
import com.epam.ta.reportportal.dao.ClusterRepository;
import com.epam.ta.reportportal.dao.LogRepository;
import com.epam.ta.reportportal.entity.cluster.Cluster;
import com.epam.ta.reportportal.ws.converter.converters.ClusterConverter;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CreateClusterHandlerImpl
implements CreateClusterHandler {
    private final ClusterRepository clusterRepository;
    private final LogRepository logRepository;

    @Autowired
    public CreateClusterHandlerImpl(ClusterRepository clusterRepository, LogRepository logRepository) {
        this.clusterRepository = clusterRepository;
        this.logRepository = logRepository;
    }

    @Override
    public void create(ClusterData clusterData) {
        Optional.ofNullable(clusterData.getClusters()).filter(CollectionUtils::isNotEmpty).ifPresent(clusters -> clusters.stream().filter(c -> Objects.nonNull(c.getClusterId())).forEach(clusterInfoRs -> {
            Cluster cluster = this.saveCluster(clusterData, (ClusterInfoRs)clusterInfoRs);
            this.saveItems((ClusterInfoRs)clusterInfoRs, cluster);
            this.updateLogs((ClusterInfoRs)clusterInfoRs, cluster);
        }));
    }

    private Cluster saveCluster(ClusterData clusterData, ClusterInfoRs clusterInfoRs) {
        Cluster cluster = this.clusterRepository.findByIndexIdAndLaunchId(clusterInfoRs.getClusterId(), clusterData.getLaunchId()).map(c -> {
            c.setMessage(clusterInfoRs.getClusterMessage());
            return c;
        }).orElseGet(() -> this.convertToCluster(clusterData, clusterInfoRs));
        return (Cluster)this.clusterRepository.save((Object)cluster);
    }

    private Cluster convertToCluster(ClusterData clusterData, ClusterInfoRs clusterInfoRs) {
        Cluster cluster = ClusterConverter.TO_CLUSTER.apply(clusterInfoRs);
        cluster.setProjectId(clusterData.getProject());
        cluster.setLaunchId(clusterData.getLaunchId());
        return cluster;
    }

    private void saveItems(ClusterInfoRs clusterInfoRs, Cluster cluster) {
        Optional.ofNullable(clusterInfoRs.getItemIds()).filter(CollectionUtils::isNotEmpty).ifPresent(itemIds -> this.clusterRepository.saveClusterTestItems(cluster, itemIds));
    }

    private void updateLogs(ClusterInfoRs clusterInfoRs, Cluster cluster) {
        Optional.ofNullable(clusterInfoRs.getLogIds()).filter(CollectionUtils::isNotEmpty).ifPresent(logIds -> this.logRepository.updateClusterIdByIdIn(cluster.getId(), clusterInfoRs.getLogIds()));
    }
}

