/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.launch.attribute;

import com.epam.ta.reportportal.commons.ReportPortalUser;
import com.epam.ta.reportportal.core.launch.attribute.AttributeHandler;
import com.epam.ta.reportportal.entity.launch.Launch;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LaunchAttributeHandlerService {
    private final List<AttributeHandler> attributeHandlers;

    @Autowired
    public LaunchAttributeHandlerService(List<AttributeHandler> attributeHandlers) {
        this.attributeHandlers = attributeHandlers;
    }

    public void handleLaunchStart(Launch launch) {
        this.attributeHandlers.forEach(handler -> handler.handleLaunchStart(launch));
    }

    public void handleLaunchUpdate(Launch launch, ReportPortalUser user) {
        this.attributeHandlers.forEach(handler -> handler.handleLaunchUpdate(launch, user));
    }
}

