/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.jasper;

import com.epam.ta.reportportal.core.jasper.util.ExportUtils;
import com.epam.ta.reportportal.entity.item.TestItem;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class TestItemPojo {
    private String type;
    private String name;
    private String status;
    private Double duration;
    private Integer total;
    private Integer passed;
    private Integer failed;
    private Integer skipped;
    private Integer automationBug;
    private Integer productBug;
    private Integer systemIssue;
    private Integer noDefect;
    private Integer toInvestigate;
    private static final Double EMPTY_DURATION = 0.0;

    public TestItemPojo(TestItem input) {
        this.type = input.getType().name();
        Optional<Object> issueDescription = Optional.empty();
        if (input.getItemResults().getIssue() != null) {
            issueDescription = Optional.ofNullable(input.getItemResults().getIssue().getIssueDescription()).map(it -> "\r\n DEFECT COMMENT: " + it);
        }
        Optional<String> description = Optional.ofNullable(input.getDescription()).map(it -> "\r\n ITEM DESCRIPTION: " + it);
        this.name = ExportUtils.adjustName(input) + description.orElse("") + issueDescription.orElse("");
        this.status = input.getItemResults().getStatus().name();
        this.duration = Objects.nonNull(input.getItemResults().getEndTime()) ? (double)Duration.between(input.getStartTime(), input.getItemResults().getEndTime()).toMillis() / 1000.0 : EMPTY_DURATION;
        Set statistics = input.getItemResults().getStatistics();
        this.total = ExportUtils.getStatisticsCounter(statistics, "statistics$executions$total");
        this.passed = ExportUtils.getStatisticsCounter(statistics, "statistics$executions$passed");
        this.failed = ExportUtils.getStatisticsCounter(statistics, "statistics$executions$failed");
        this.skipped = ExportUtils.getStatisticsCounter(statistics, "statistics$executions$skipped");
        this.automationBug = ExportUtils.getStatisticsCounter(statistics, "statistics$defects$automation_bug$total");
        this.productBug = ExportUtils.getStatisticsCounter(statistics, "statistics$defects$product_bug$total");
        this.systemIssue = ExportUtils.getStatisticsCounter(statistics, "statistics$defects$system_issue$total");
        this.noDefect = ExportUtils.getStatisticsCounter(statistics, "statistics$defects$no_defect$total");
        this.toInvestigate = ExportUtils.getStatisticsCounter(statistics, "statistics$defects$to_investigate$total");
    }

    public void setType(String value) {
        this.type = value;
    }

    public String getType() {
        return this.type;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getName() {
        return this.name;
    }

    public void setStatus(String value) {
        this.status = value;
    }

    public String getStatus() {
        return this.status;
    }

    public void setTotal(Integer value) {
        this.total = value;
    }

    public Integer getTotal() {
        return this.total;
    }

    public void setPased(Integer value) {
        this.passed = value;
    }

    public Integer getPassed() {
        return this.passed;
    }

    public void setFailed(Integer value) {
        this.failed = value;
    }

    public Integer getFailed() {
        return this.failed;
    }

    public void setSkipped(Integer value) {
        this.skipped = value;
    }

    public Integer getSkipped() {
        return this.skipped;
    }

    public void setAutomationBug(Integer value) {
        this.automationBug = value;
    }

    public Integer getAutomationBug() {
        return this.automationBug;
    }

    public void setProductBug(Integer value) {
        this.productBug = value;
    }

    public Integer getProductBug() {
        return this.productBug;
    }

    public void setSystemIssue(Integer value) {
        this.systemIssue = value;
    }

    public Integer getSystemIssue() {
        return this.systemIssue;
    }

    public void setNoDefect(Integer value) {
        this.noDefect = value;
    }

    public Integer getNoDefect() {
        return this.noDefect;
    }

    public void setToInvestigate(Integer value) {
        this.toInvestigate = value;
    }

    public Integer getToInvestigate() {
        return this.toInvestigate;
    }

    public Double getDuration() {
        return this.duration;
    }

    public void setDuration(Double duration) {
        this.duration = duration;
    }

    public void setPassed(Integer passed) {
        this.passed = passed;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TestItemPojo{");
        sb.append("type='").append(this.type).append('\'');
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", status='").append(this.status).append('\'');
        sb.append(", duration=").append(this.duration);
        sb.append(", total=").append(this.total);
        sb.append(", passed=").append(this.passed);
        sb.append(", failed=").append(this.failed);
        sb.append(", skipped=").append(this.skipped);
        sb.append(", automationBug=").append(this.automationBug);
        sb.append(", productBug=").append(this.productBug);
        sb.append(", systemIssue=").append(this.systemIssue);
        sb.append(", noDefect=").append(this.noDefect);
        sb.append(", toInvestigate=").append(this.toInvestigate);
        sb.append('}');
        return sb.toString();
    }
}

