/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.validator.state;

import com.epam.reportportal.rules.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.item.validator.state.TestItemValidator;
import com.epam.ta.reportportal.entity.item.TestItem;
import java.util.Objects;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Service;

@Service
public class NotRetryValidator
implements TestItemValidator,
Ordered {
    @Override
    public boolean validate(TestItem item) {
        return Objects.isNull(item.getRetryOf()) && Objects.nonNull(item.getLaunchId());
    }

    @Override
    public String provide(TestItem item) {
        return (String)Suppliers.formattedSupplier((String)"Test item = {} is a retry", (Object[])new Object[]{item.getItemId()}).get();
    }

    public int getOrder() {
        return 2;
    }
}

