/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.validator.parent;

import com.epam.reportportal.rules.commons.validation.BusinessRule;
import com.epam.reportportal.rules.exception.ErrorType;
import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.core.item.validator.parent.ParentItemValidator;
import com.epam.ta.reportportal.entity.item.TestItem;
import com.epam.ta.reportportal.ws.reporting.StartTestItemRQ;
import java.time.Instant;
import java.util.function.Predicate;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Service;

@Service
public class StartTimeConditionValidator
implements ParentItemValidator,
Ordered {
    @Override
    public void validate(StartTestItemRQ rq, TestItem parent) {
        BusinessRule.expect((Object)rq.getStartTime(), (Predicate)Preconditions.sameTimeOrLater((Instant)parent.getStartTime())).verify(ErrorType.CHILD_START_TIME_EARLIER_THAN_PARENT, new Object[]{rq.getStartTime(), parent.getStartTime(), parent.getItemId()});
    }

    public int getOrder() {
        return 3;
    }
}

